/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.concurrent;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.concurrent.AsyncIOProcessor;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;

public abstract class BufferedAsyncIOProcessor<Item>
extends AsyncIOProcessor<Item> {
    private final ThreadPool threadpool;
    private final Supplier<TimeValue> bufferIntervalSupplier;

    protected BufferedAsyncIOProcessor(Logger logger, int queueSize, ThreadContext threadContext, ThreadPool threadpool, Supplier<TimeValue> bufferIntervalSupplier) {
        super(logger, queueSize, threadContext);
        this.threadpool = threadpool;
        this.bufferIntervalSupplier = bufferIntervalSupplier;
    }

    @Override
    public void put(Item item, Consumer<Exception> listener) {
        Objects.requireNonNull(item, "item must not be null");
        Objects.requireNonNull(listener, "listener must not be null");
        this.addToQueue(item, listener);
        this.scheduleProcess();
    }

    private void scheduleProcess() {
        if (!this.getQueue().isEmpty() && this.getPromiseSemaphore().tryAcquire()) {
            try {
                this.threadpool.schedule(this::process, this.getBufferInterval(), this.getBufferProcessThreadPoolName());
            }
            catch (Exception e) {
                this.getLogger().error("failed to schedule process");
                this.processSchedulingFailure(e);
                this.getPromiseSemaphore().release();
                this.scheduleProcess();
            }
        }
    }

    private void processSchedulingFailure(Exception e) {
        ArrayList candidates = new ArrayList();
        this.getQueue().drainTo(candidates);
        this.notifyList(candidates, e);
    }

    private void process() {
        this.drainAndProcessAndRelease(new ArrayList());
        this.scheduleProcess();
    }

    private TimeValue getBufferInterval() {
        long bufferInterval = this.bufferIntervalSupplier.get().getNanos();
        long timeSinceLastRunStartInNS = System.nanoTime() - this.getLastRunStartTimeInNs();
        if (timeSinceLastRunStartInNS >= bufferInterval) {
            return TimeValue.ZERO;
        }
        return TimeValue.timeValueNanos((long)(bufferInterval - timeSinceLastRunStartInNS));
    }

    protected abstract String getBufferProcessThreadPoolName();

    public Supplier<TimeValue> getBufferIntervalSupplier() {
        return this.bufferIntervalSupplier;
    }
}

