/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.concurrent;

import io.skylite.common.ExceptionsHelper;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.threadpool.RunnableTaskExecutionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.concurrent.ResizableBlockingQueue;
import io.skylite.common.util.concurrent.SizeBlockingQueue;
import io.skylite.common.util.concurrent.SkyliteAbortPolicy;
import io.skylite.common.util.concurrent.TimedRunnable;
import io.skylite.common.util.concurrent.WrappedRunnable;
import io.skylite.common.util.concurrent.XRejectedExecutionHandler;
import io.skylite.core.common.concurrent.PrioritizedSkyliteThreadPoolExecutor;
import io.skylite.core.common.concurrent.QueueResizableSkyliteThreadPoolExecutor;
import io.skylite.core.common.concurrent.QueueResizingSkyliteThreadPoolExecutor;
import io.skylite.core.common.concurrent.SkyliteThreadPoolExecutor;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.TaskAwareRunnable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class SkyliteExecutors {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SkyliteExecutors.class);
    public static final Setting<Integer> PROCESSORS_SETTING = new Setting<Integer>("processors", s -> Integer.toString(Runtime.getRuntime().availableProcessors()), SkyliteExecutors.processorsParser("processors"), Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting<Integer> NODE_PROCESSORS_SETTING = new Setting<Integer>("node.processors", PROCESSORS_SETTING, SkyliteExecutors.processorsParser("node.processors"), Setting.Property.NodeScope);
    private static final ExecutorService DIRECT_EXECUTOR_SERVICE = new DirectExecutorService();

    private static Function<String, Integer> processorsParser(String name) {
        return s -> {
            int availableProcessors;
            int value = Setting.parseInt(s, 1, name);
            if (value > (availableProcessors = Runtime.getRuntime().availableProcessors())) {
                deprecationLogger.deprecate("processors_" + name, "setting [{}] to value [{}] which is more than available processors [{}] is deprecated", name, value, availableProcessors);
            }
            return value;
        };
    }

    public static int allocatedProcessors(Settings settings) {
        return NODE_PROCESSORS_SETTING.get(settings);
    }

    public static PrioritizedSkyliteThreadPoolExecutor newSinglePrioritizing(String name, ThreadFactory threadFactory, ThreadContext contextHolder, ScheduledExecutorService timer) {
        return new PrioritizedSkyliteThreadPoolExecutor(name, 1, 1, 0L, TimeUnit.MILLISECONDS, threadFactory, contextHolder, timer);
    }

    public static SkyliteThreadPoolExecutor newScaling(String name, int min, int max, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, ThreadContext contextHolder) {
        ExecutorScalingQueue<Runnable> queue = new ExecutorScalingQueue<Runnable>();
        SkyliteThreadPoolExecutor executor = new SkyliteThreadPoolExecutor(name, min, max, keepAliveTime, unit, queue, threadFactory, new ForceQueuePolicy(), contextHolder);
        queue.executor = executor;
        return executor;
    }

    public static SkyliteThreadPoolExecutor newFixed(String name, int size, int queueCapacity, ThreadFactory threadFactory, ThreadContext contextHolder) {
        BlockingQueue queue = queueCapacity < 0 ? ConcurrentCollections.newBlockingQueue() : new SizeBlockingQueue(ConcurrentCollections.newBlockingQueue(), queueCapacity);
        return new SkyliteThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, queue, threadFactory, (XRejectedExecutionHandler)new SkyliteAbortPolicy(), contextHolder);
    }

    public static SkyliteThreadPoolExecutor newResizable(String name, int size, int queueCapacity, ThreadFactory threadFactory, ThreadContext contextHolder, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener) {
        if (queueCapacity <= 0) {
            throw new IllegalArgumentException("queue capacity for [" + name + "] executor must be positive, got: " + queueCapacity);
        }
        Function<Runnable, WrappedRunnable> runnableWrapper = runnableTaskListener != null ? runnable -> {
            TaskAwareRunnable taskAwareRunnable = new TaskAwareRunnable(contextHolder, (Runnable)runnable, runnableTaskListener);
            return new TimedRunnable((Runnable)((Object)taskAwareRunnable));
        } : TimedRunnable::new;
        return new QueueResizableSkyliteThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, (ResizableBlockingQueue<Runnable>)new ResizableBlockingQueue(ConcurrentCollections.newBlockingQueue(), queueCapacity), runnableWrapper, threadFactory, (XRejectedExecutionHandler)new SkyliteAbortPolicy(), contextHolder);
    }

    public static SkyliteThreadPoolExecutor newAutoQueueFixed(String name, int size, int initialQueueCapacity, int minQueueSize, int maxQueueSize, int frameSize, TimeValue targetedResponseTime, ThreadFactory threadFactory, ThreadContext contextHolder) {
        if (initialQueueCapacity <= 0) {
            throw new IllegalArgumentException("initial queue capacity for [" + name + "] executor must be positive, got: " + initialQueueCapacity);
        }
        ResizableBlockingQueue queue = new ResizableBlockingQueue(ConcurrentCollections.newBlockingQueue(), initialQueueCapacity);
        return new QueueResizingSkyliteThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, (ResizableBlockingQueue<Runnable>)queue, minQueueSize, maxQueueSize, TimedRunnable::new, frameSize, targetedResponseTime, threadFactory, (XRejectedExecutionHandler)new SkyliteAbortPolicy(), contextHolder);
    }

    public static Throwable rethrowErrors(Runnable runnable) {
        block7: {
            if (runnable instanceof RunnableFuture) {
                assert (((RunnableFuture)runnable).isDone());
                try {
                    ((RunnableFuture)runnable).get();
                }
                catch (Exception e) {
                    assert (e instanceof CancellationException || e instanceof InterruptedException || e instanceof ExecutionException) : e;
                    Optional maybeError = ExceptionsHelper.maybeError((Throwable)e);
                    if (maybeError.isPresent()) {
                        throw (Error)maybeError.get();
                    }
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(e instanceof ExecutionException)) break block7;
                    return e.getCause();
                }
            }
        }
        return null;
    }

    public static ExecutorService newDirectExecutorService() {
        return DIRECT_EXECUTOR_SERVICE;
    }

    public static String threadName(Settings settings, String namePrefix) {
        if (CommonSettings.NODE_NAME_SETTING.exists(settings)) {
            return SkyliteExecutors.threadName(CommonSettings.NODE_NAME_SETTING.get(settings), namePrefix);
        }
        return SkyliteExecutors.threadName("", namePrefix);
    }

    public static String threadName(String nodeName, String namePrefix) {
        return "lucenia" + (nodeName.isEmpty() ? "" : "[") + nodeName + (nodeName.isEmpty() ? "" : "]") + "[" + namePrefix + "]";
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String namePrefix) {
        return SkyliteExecutors.daemonThreadFactory(SkyliteExecutors.threadName(settings, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String nodeName, String namePrefix) {
        assert (nodeName != null && !nodeName.isEmpty());
        return SkyliteExecutors.daemonThreadFactory(SkyliteExecutors.threadName(nodeName, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        return new SkyliteThreadFactory(namePrefix);
    }

    private SkyliteExecutors() {
    }

    static class ExecutorScalingQueue<E>
    extends LinkedTransferQueue<E> {
        ThreadPoolExecutor executor;

        ExecutorScalingQueue() {
        }

        @Override
        public boolean offer(E e) {
            if (!this.tryTransfer(e)) {
                int left = this.executor.getMaximumPoolSize() - this.executor.getCorePoolSize();
                if (left > 0) {
                    return false;
                }
                return super.offer(e);
            }
            return true;
        }
    }

    static class ForceQueuePolicy
    implements XRejectedExecutionHandler {
        ForceQueuePolicy() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                assert (executor.getQueue() instanceof ExecutorScalingQueue);
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public long rejected() {
            return 0L;
        }
    }

    static class SkyliteThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        SkyliteThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + "[T#" + this.threadNumber.getAndIncrement() + "]", 0L);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class DirectExecutorService
    extends AbstractExecutorService {
        @SuppressForbidden(reason="properly rethrowing errors, see OpenSearchExecutors.rethrowErrors")
        DirectExecutorService() {
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            command.run();
            SkyliteExecutors.rethrowErrors(command);
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(PROCESSORS_SETTING, NODE_PROCESSORS_SETTING);
        }
    }
}

