/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.Binding;
import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.InjectorShell;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.spi.Element;
import io.skylite.core.common.inject.spi.ElementVisitor;
import io.skylite.core.common.inject.spi.Message;
import io.skylite.core.common.inject.spi.ScopeBinding;
import io.skylite.core.common.inject.spi.SupplierLookup;
import java.util.Iterator;
import java.util.List;

abstract class AbstractProcessor
implements ElementVisitor<Boolean> {
    protected Errors errors;
    protected InjectorImpl injector;

    protected AbstractProcessor(Errors errors) {
        this.errors = errors;
    }

    public void process(Iterable<InjectorShell> isolatedInjectorBuilders) {
        for (InjectorShell injectorShell : isolatedInjectorBuilders) {
            this.process(injectorShell.getInjector(), injectorShell.getElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InjectorImpl injector, List<Element> elements) {
        Errors errorsAnyElement = this.errors;
        this.injector = injector;
        try {
            Iterator<Element> i = elements.iterator();
            while (i.hasNext()) {
                Element element = i.next();
                this.errors = errorsAnyElement.withSource(element.getSource());
                Boolean allDone = element.acceptVisitor(this);
                if (!allDone.booleanValue()) continue;
                i.remove();
            }
        }
        finally {
            this.errors = errorsAnyElement;
            this.injector = null;
        }
    }

    @Override
    public Boolean visit(Message message) {
        return false;
    }

    @Override
    public Boolean visit(ScopeBinding scopeBinding) {
        return false;
    }

    @Override
    public <T> Boolean visit(Binding<T> binding) {
        return false;
    }

    @Override
    public <T> Boolean visit(SupplierLookup<T> supplierLookup) {
        return false;
    }
}

