/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.common.util.set.Sets;
import io.skylite.core.common.inject.AbstractModule;
import io.skylite.core.common.inject.AbstractProcessor;
import io.skylite.core.common.inject.Binder;
import io.skylite.core.common.inject.Binding;
import io.skylite.core.common.inject.BoundSupplierFactory;
import io.skylite.core.common.inject.ConstantFactory;
import io.skylite.core.common.inject.FactoryProxy;
import io.skylite.core.common.inject.Initializable;
import io.skylite.core.common.inject.Initializer;
import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.InternalFactoryToProviderAdapter;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.MembersInjector;
import io.skylite.core.common.inject.Module;
import io.skylite.core.common.inject.Scope;
import io.skylite.core.common.inject.Scopes;
import io.skylite.core.common.inject.TypeLiteral;
import io.skylite.core.common.inject.internal.Annotations;
import io.skylite.core.common.inject.internal.BindingImpl;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.InstanceBindingImpl;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.internal.LinkedBindingImpl;
import io.skylite.core.common.inject.internal.LinkedSupplierBindingImpl;
import io.skylite.core.common.inject.internal.ProviderInstanceBindingImpl;
import io.skylite.core.common.inject.internal.Scoping;
import io.skylite.core.common.inject.internal.SupplierMethod;
import io.skylite.core.common.inject.internal.UntargettedBindingImpl;
import io.skylite.core.common.inject.spi.BindingTargetVisitor;
import io.skylite.core.common.inject.spi.InjectionPoint;
import io.skylite.core.common.inject.spi.InstanceBinding;
import io.skylite.core.common.inject.spi.LinkedKeyBinding;
import io.skylite.core.common.inject.spi.ProviderInstanceBinding;
import io.skylite.core.common.inject.spi.SupplierKeyBinding;
import io.skylite.core.common.inject.spi.UntargettedBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

class BindingProcessor
extends AbstractProcessor {
    private final List<CreationListener> creationListeners = new ArrayList<CreationListener>();
    private final Initializer initializer;
    private final List<Runnable> uninitializedBindings = new ArrayList<Runnable>();
    private static final Set<Class<?>> FORBIDDEN_TYPES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Class[]{AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, Module.class, Supplier.class, Scope.class, TypeLiteral.class}));

    BindingProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        final Object source = command.getSource();
        if (Void.class.equals(command.getKey().getRawType())) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getProviderInstance() instanceof SupplierMethod) {
                this.errors.voidSupplierMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        final Key<T> key = command.getKey();
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType == Supplier.class) {
            this.errors.bindingToSupplier();
            return true;
        }
        this.validateKey(command.getSource(), command.getKey());
        final Scoping scoping = Scopes.makeInjectable(((BindingImpl)command).getScoping(), this.injector, this.errors);
        command.acceptTargetVisitor(new BindingTargetVisitor<T, Void>(){

            @Override
            public Void visit(InstanceBinding<? extends T> binding) {
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, instance, source, injectionPoints);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scopes.scope(BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, injectionPoints, instance));
                return null;
            }

            @Override
            public Void visit(ProviderInstanceBinding<? extends T> binding) {
                Supplier provider = binding.getProviderInstance();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, provider, source, injectionPoints);
                InternalFactoryToProviderAdapter factory = new InternalFactoryToProviderAdapter(initializable, source);
                InternalFactory scopedFactory = Scopes.scope(BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, provider, injectionPoints));
                return null;
            }

            @Override
            public Void visit(SupplierKeyBinding<? extends T> binding) {
                Key supplierKey = binding.getSupplierKey();
                BoundSupplierFactory boundSupplierFactory = new BoundSupplierFactory(BindingProcessor.this.injector, supplierKey, source);
                BindingProcessor.this.creationListeners.add(boundSupplierFactory);
                InternalFactory scopedFactory = Scopes.scope(BindingProcessor.this.injector, boundSupplierFactory, scoping);
                BindingProcessor.this.putBinding(new LinkedSupplierBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, supplierKey));
                return null;
            }

            @Override
            public Void visit(LinkedKeyBinding<? extends T> binding) {
                Key linkedKey = binding.getLinkedKey();
                if (key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding();
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, key, linkedKey, source);
                BindingProcessor.this.creationListeners.add(factory);
                InternalFactory scopedFactory = Scopes.scope(BindingProcessor.this.injector, factory, scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, key, source, scopedFactory, scoping, linkedKey));
                return null;
            }

            @Override
            public Void visit(UntargettedBinding<? extends T> untargetted) {
                BindingImpl binding;
                if (key.hasAnnotationType()) {
                    BindingProcessor.this.errors.missingImplementation(key);
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, key, source));
                    return null;
                }
                try {
                    binding = BindingProcessor.this.injector.createUnitializedBinding(key, scoping, source, BindingProcessor.this.errors);
                    BindingProcessor.this.putBinding(binding);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, key, source));
                    return null;
                }
                BindingProcessor.this.uninitializedBindings.add(() -> {
                    try {
                        ((InjectorImpl)binding.getInjector()).initializeBinding(binding, BindingProcessor.this.errors.withSource(source));
                    }
                    catch (ErrorsException e) {
                        BindingProcessor.this.errors.merge(e.getErrors());
                    }
                });
                return null;
            }

            @Override
            public Void visit() {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }
        });
        return true;
    }

    private <T> void validateKey(Object source, Key<T> key) {
        Annotations.checkForMisplacedScopeAnnotations(key.getRawType(), source, this.errors);
    }

    <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injector, Key<T> key, Object source) {
        return new UntargettedBindingImpl<T>(injector, key, source);
    }

    public void initializeBindings() {
        for (Runnable initializer : this.uninitializedBindings) {
            initializer.run();
        }
    }

    public void runCreationListeners() {
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(this.errors);
        }
    }

    private void putBinding(BindingImpl<?> binding) {
        Key<?> key = binding.getKey();
        Class<?> rawType = key.getRawType();
        if (FORBIDDEN_TYPES.contains(rawType)) {
            this.errors.cannotBindToGuiceType(rawType.getSimpleName());
            return;
        }
        BindingImpl<?> original = this.injector.state.getExplicitBinding(key);
        if (original != null) {
            this.errors.bindingAlreadySet(key, original.getSource());
            return;
        }
        this.injector.state.parent().denylist(key);
        this.injector.state.putBinding(key, binding);
    }

    static interface CreationListener {
        public void notify(Errors var1);
    }
}

