/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.ConstructionProxy;
import io.skylite.core.common.inject.ConstructionProxyFactory;
import io.skylite.core.common.inject.spi.InjectionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

class DefaultConstructionProxyFactory<T>
implements ConstructionProxyFactory<T> {
    private final InjectionPoint injectionPoint;

    DefaultConstructionProxyFactory(InjectionPoint injectionPoint) {
        this.injectionPoint = injectionPoint;
    }

    @Override
    public ConstructionProxy<T> create() {
        final Constructor constructor = (Constructor)this.injectionPoint.getMember();
        return new ConstructionProxy<T>(){

            @Override
            public T newInstance(Object ... arguments) throws InvocationTargetException {
                try {
                    return constructor.newInstance(arguments);
                }
                catch (InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError("Wrong access modifiers on " + String.valueOf(constructor), e);
                }
            }

            @Override
            public InjectionPoint getInjectionPoint() {
                return DefaultConstructionProxyFactory.this.injectionPoint;
            }
        };
    }
}

