/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.Binding;
import io.skylite.core.common.inject.BindingProcessor;
import io.skylite.core.common.inject.ContextualCallable;
import io.skylite.core.common.inject.DeferredLookups;
import io.skylite.core.common.inject.Initializer;
import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.InjectorShell;
import io.skylite.core.common.inject.LookupProcessor;
import io.skylite.core.common.inject.Module;
import io.skylite.core.common.inject.Stage;
import io.skylite.core.common.inject.internal.BindingImpl;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.InternalContext;
import io.skylite.core.common.inject.internal.Stopwatch;
import io.skylite.core.common.inject.spi.Dependency;
import java.util.List;

class InjectorBuilder {
    private final Stopwatch stopwatch = new Stopwatch();
    private final Errors errors = new Errors();
    private final Initializer initializer = new Initializer();
    private final BindingProcessor bindingProcesor;
    private final InjectorShell.Builder shellBuilder = new InjectorShell.Builder();
    private List<InjectorShell> shells;

    InjectorBuilder() {
        this.bindingProcesor = new BindingProcessor(this.errors, this.initializer);
    }

    InjectorBuilder addModules(Iterable<? extends Module> modules) {
        this.shellBuilder.addModules(modules);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Injector build() {
        Object object = this.shellBuilder.lock();
        synchronized (object) {
            this.shells = this.shellBuilder.build(this.bindingProcesor, this.stopwatch, this.errors);
            this.stopwatch.resetAndLog("Injector construction");
            this.initializeStatically();
        }
        this.injectDynamically();
        return this.primaryInjector();
    }

    private void initializeStatically() {
        this.bindingProcesor.initializeBindings();
        this.stopwatch.resetAndLog("Binding initialization");
        for (InjectorShell shell : this.shells) {
            shell.getInjector().index();
        }
        this.stopwatch.resetAndLog("Binding indexing");
        this.bindingProcesor.runCreationListeners();
        this.stopwatch.resetAndLog("Binding validation");
        this.initializer.validateOustandingInjections(this.errors);
        this.stopwatch.resetAndLog("Instance member validation");
        new LookupProcessor(this.errors).process(this.shells);
        for (InjectorShell shell : this.shells) {
            ((DeferredLookups)shell.getInjector().lookups).initialize(this.errors);
        }
        this.stopwatch.resetAndLog("Provider verification");
        for (InjectorShell shell : this.shells) {
            if (!shell.getElements().isEmpty()) {
                throw new AssertionError((Object)("Failed to execute " + String.valueOf(shell.getElements())));
            }
        }
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    private Injector primaryInjector() {
        return this.shells.get(0).getInjector();
    }

    private void injectDynamically() {
        this.initializer.injectAll(this.errors);
        this.stopwatch.resetAndLog("Instance injection");
        this.errors.throwCreationExceptionIfErrorsExist();
        for (InjectorShell shell : this.shells) {
            this.loadEagerSingletons(shell.getInjector(), Stage.DEVELOPMENT, this.errors);
        }
        this.stopwatch.resetAndLog("Preloading singletons");
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    public void loadEagerSingletons(InjectorImpl injector, Stage stage, Errors errors) {
        for (Binding<?> binding : injector.state.getExplicitBindingsThisLevel().values()) {
            this.loadEagerSingletons(injector, stage, errors, (BindingImpl)binding);
        }
        for (BindingImpl bindingImpl : injector.jitBindings.values()) {
            this.loadEagerSingletons(injector, stage, errors, bindingImpl);
        }
    }

    private void loadEagerSingletons(InjectorImpl injector, Stage stage, final Errors errors, final BindingImpl<?> binding) {
        if (binding.getScoping().isEagerSingleton(stage)) {
            try {
                injector.callInContext(new ContextualCallable<Void>(){
                    final Dependency<?> dependency;
                    {
                        this.dependency = Dependency.get(binding.getKey());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call(InternalContext context) {
                        context.setDependency(this.dependency);
                        Errors errorsForBinding = errors.withSource(this.dependency);
                        try {
                            binding.getInternalFactory().get(errorsForBinding, context, this.dependency);
                        }
                        catch (ErrorsException e) {
                            errorsForBinding.merge(e.getErrors());
                        }
                        finally {
                            context.setDependency(null);
                        }
                        return null;
                    }
                });
            }
            catch (ErrorsException e) {
                throw new AssertionError();
            }
        }
    }
}

