/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.common.Classes;
import io.skylite.core.common.inject.Binding;
import io.skylite.core.common.inject.ConfigurationException;
import io.skylite.core.common.inject.ConstantFactory;
import io.skylite.core.common.inject.ConstructorBindingImpl;
import io.skylite.core.common.inject.ConstructorInjectorStore;
import io.skylite.core.common.inject.ContextualCallable;
import io.skylite.core.common.inject.DeferredLookups;
import io.skylite.core.common.inject.ImplementedBy;
import io.skylite.core.common.inject.Initializables;
import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.Lookups;
import io.skylite.core.common.inject.MembersInjector;
import io.skylite.core.common.inject.MembersInjectorImpl;
import io.skylite.core.common.inject.MembersInjectorStore;
import io.skylite.core.common.inject.ProvisionException;
import io.skylite.core.common.inject.Scopes;
import io.skylite.core.common.inject.SingleParameterInjector;
import io.skylite.core.common.inject.State;
import io.skylite.core.common.inject.SuppliedBy;
import io.skylite.core.common.inject.TypeLiteral;
import io.skylite.core.common.inject.internal.Annotations;
import io.skylite.core.common.inject.internal.BindingImpl;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.InstanceBindingImpl;
import io.skylite.core.common.inject.internal.InternalContext;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.internal.LinkedBindingImpl;
import io.skylite.core.common.inject.internal.LinkedSupplierBindingImpl;
import io.skylite.core.common.inject.internal.MatcherAndConverter;
import io.skylite.core.common.inject.internal.Scoping;
import io.skylite.core.common.inject.internal.SourceProvider;
import io.skylite.core.common.inject.internal.ToStringBuilder;
import io.skylite.core.common.inject.spi.BindingTargetVisitor;
import io.skylite.core.common.inject.spi.ConvertedConstantBinding;
import io.skylite.core.common.inject.spi.Dependency;
import io.skylite.core.common.inject.spi.SupplierBinding;
import io.skylite.core.common.inject.spi.SupplierKeyBinding;
import io.skylite.core.common.inject.util.Suppliers;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

class InjectorImpl
implements Injector,
Lookups {
    final State state;
    BindingsMultimap bindingsMultimap = new BindingsMultimap();
    Map<Key<?>, BindingImpl<?>> jitBindings = new HashMap();
    Lookups lookups = new DeferredLookups(this);
    ConstructorInjectorStore constructors = new ConstructorInjectorStore(this);
    MembersInjectorStore membersInjectorStore;
    private final ThreadLocal<Object[]> localContext;

    InjectorImpl(State state) {
        this.state = state;
        this.localContext = new ThreadLocal();
    }

    void index() {
        for (Binding<?> binding : this.state.getExplicitBindingsThisLevel().values()) {
            this.index(binding);
        }
    }

    <T> void index(Binding<T> binding) {
        this.bindingsMultimap.put(binding.getKey().getTypeLiteral(), binding);
    }

    @Override
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        return this.bindingsMultimap.getAll(type);
    }

    public <T> BindingImpl<T> getBindingOrThrow(Key<T> key, Errors errors) throws ErrorsException {
        BindingImpl<T> binding = this.state.getExplicitBinding(key);
        if (binding != null) {
            return binding;
        }
        return this.getJustInTimeBinding(key, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BindingImpl<T> getJustInTimeBinding(Key<T> key, Errors errors) throws ErrorsException {
        Object object = this.state.lock();
        synchronized (object) {
            BindingImpl<?> binding = this.jitBindings.get(key);
            if (binding != null) {
                return binding;
            }
            return this.createJustInTimeBindingRecursive(key, errors);
        }
    }

    static boolean isSupplier(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(Supplier.class);
    }

    static boolean isMembersInjector(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(MembersInjector.class) && !key.hasAnnotationType();
    }

    private <T> BindingImpl<MembersInjector<T>> createMembersInjectorBinding(Key<MembersInjector<T>> key, Errors errors) throws ErrorsException {
        Type membersInjectorType = key.getTypeLiteral().getType();
        if (!(membersInjectorType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawMembersInjector().toException();
        }
        TypeLiteral<?> instanceType = TypeLiteral.get(((ParameterizedType)membersInjectorType).getActualTypeArguments()[0]);
        MembersInjectorImpl<?> membersInjector = this.membersInjectorStore.get(instanceType, errors);
        ConstantFactory factory = new ConstantFactory(Initializables.of(membersInjector));
        return new InstanceBindingImpl<MembersInjector<T>>(this, key, SourceProvider.UNKNOWN_SOURCE, factory, Collections.emptySet(), membersInjector);
    }

    private <T> BindingImpl<Supplier<T>> createSupplierBinding(Key<Supplier<T>> key, Errors errors) throws ErrorsException {
        Type supplierType = key.getTypeLiteral().getType();
        if (!(supplierType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawSupplier().toException();
        }
        Type entryType = ((ParameterizedType)supplierType).getActualTypeArguments()[0];
        Key<?> supplierKey = key.ofType(entryType);
        BindingImpl<?> delegate = this.getBindingOrThrow(supplierKey, errors);
        return new SupplierBindingImpl<T>(this, key, delegate);
    }

    private <T> BindingImpl<T> convertConstantStringBinding(Key<T> key, Errors errors) throws ErrorsException {
        BindingImpl<String> stringBinding = this.state.getExplicitBinding(key.ofStringType());
        if (stringBinding == null || !stringBinding.isConstant()) {
            return null;
        }
        String stringValue = stringBinding.getSupplier().get();
        Object source = stringBinding.getSource();
        TypeLiteral<T> type = key.getTypeLiteral();
        MatcherAndConverter matchingConverter = this.state.getConverter(stringValue, type, errors, source);
        if (matchingConverter == null) {
            return null;
        }
        try {
            Object converted = matchingConverter.getTypeConverter().convert(stringValue, type);
            if (converted == null) {
                throw errors.converterReturnedNull(stringValue, source, type, matchingConverter).toException();
            }
            if (!type.getRawType().isInstance(converted)) {
                throw errors.conversionTypeError(stringValue, source, type, matchingConverter, converted).toException();
            }
            return new ConvertedConstantBindingImpl<Object>(this, key, converted, stringBinding);
        }
        catch (RuntimeException e) {
            throw errors.conversionError(stringValue, source, type, matchingConverter, e).toException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void initializeBinding(BindingImpl<T> binding, Errors errors) throws ErrorsException {
        if (binding instanceof ConstructorBindingImpl) {
            Key<T> key = binding.getKey();
            this.jitBindings.put(key, binding);
            boolean successful = false;
            try {
                ((ConstructorBindingImpl)binding).initialize(this, errors);
                successful = true;
            }
            finally {
                if (!successful) {
                    this.jitBindings.remove(key);
                }
            }
        }
    }

    <T> BindingImpl<T> createUnitializedBinding(Key<T> key, Scoping scoping, Object source, Errors errors) throws ErrorsException {
        Class<? extends Annotation> scopeAnnotation;
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType.isArray() || rawType.isEnum()) {
            throw errors.missingImplementation(key).toException();
        }
        if (rawType == TypeLiteral.class) {
            BindingImpl<TypeLiteral<T>> binding = this.createTypeLiteralBinding(key, errors);
            return binding;
        }
        ImplementedBy implementedBy = rawType.getAnnotation(ImplementedBy.class);
        if (implementedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source, errors);
            return this.createImplementedByBinding(key, scoping, implementedBy, errors);
        }
        SuppliedBy suppliedBy = rawType.getAnnotation(SuppliedBy.class);
        if (suppliedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source, errors);
            return this.createProvidedByBinding(key, scoping, suppliedBy, errors);
        }
        if (Modifier.isAbstract(rawType.getModifiers())) {
            throw errors.missingImplementation(key).toException();
        }
        if (Classes.isInnerClass(rawType)) {
            throw errors.cannotInjectInnerClass(rawType).toException();
        }
        if (!scoping.isExplicitlyScoped() && (scopeAnnotation = Annotations.findScopeAnnotation(errors, rawType)) != null) {
            scoping = Scopes.makeInjectable(Scoping.forAnnotation(scopeAnnotation), this, errors.withSource(rawType));
        }
        return ConstructorBindingImpl.create(this, key, source, scoping);
    }

    private <T> BindingImpl<TypeLiteral<T>> createTypeLiteralBinding(Key<TypeLiteral<T>> key, Errors errors) throws ErrorsException {
        Type typeLiteralType = key.getTypeLiteral().getType();
        if (!(typeLiteralType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawTypeLiteral().toException();
        }
        ParameterizedType parameterizedType = (ParameterizedType)typeLiteralType;
        Type innerType = parameterizedType.getActualTypeArguments()[0];
        if (!(innerType instanceof Class || innerType instanceof GenericArrayType || innerType instanceof ParameterizedType)) {
            throw errors.cannotInjectTypeLiteralOf(innerType).toException();
        }
        TypeLiteral<?> value = TypeLiteral.get(innerType);
        ConstantFactory factory = new ConstantFactory(Initializables.of(value));
        return new InstanceBindingImpl<TypeLiteral<T>>(this, key, SourceProvider.UNKNOWN_SOURCE, factory, Collections.emptySet(), value);
    }

    <T> BindingImpl<T> createProvidedByBinding(Key<T> key, Scoping scoping, SuppliedBy suppliedBy, Errors errors) throws ErrorsException {
        Class rawType = key.getTypeLiteral().getRawType();
        Class<? extends Supplier<?>> supplierType = suppliedBy.value();
        if (supplierType == rawType) {
            throw errors.recursiveSupplierType().toException();
        }
        Key<? extends Supplier<?>> supplierKey = Key.get(supplierType);
        BindingImpl<? extends Supplier<?>> supplierBinding = this.getBindingOrThrow(supplierKey, errors);
        InternalFactory<Object> internalFactory = (errors1, context, dependency) -> {
            errors1 = errors1.withSource(supplierKey);
            Supplier supplier = (Supplier)supplierBinding.getInternalFactory().get(errors1, context, dependency);
            try {
                Object o = supplier.get();
                if (o != null && !rawType.isInstance(o)) {
                    throw errors1.subtypeNotSupplied(supplierType, rawType).toException();
                }
                Object t = o;
                return t;
            }
            catch (RuntimeException e) {
                throw errors1.errorInSupplier(e).toException();
            }
        };
        return new LinkedSupplierBindingImpl<Object>(this, key, rawType, Scopes.scope(this, internalFactory, scoping), scoping, supplierKey);
    }

    <T> BindingImpl<T> createImplementedByBinding(Key<T> key, Scoping scoping, ImplementedBy implementedBy, Errors errors) throws ErrorsException {
        Class<T> rawType = key.getTypeLiteral().getRawType();
        Class<?> implementationType = implementedBy.value();
        if (implementationType == rawType) {
            throw errors.recursiveImplementationType().toException();
        }
        if (!rawType.isAssignableFrom(implementationType)) {
            throw errors.notASubtype(implementationType, rawType).toException();
        }
        Class<?> subclass = implementationType;
        Key<?> targetKey = Key.get(subclass);
        BindingImpl<?> targetBinding = this.getBindingOrThrow(targetKey, errors);
        InternalFactory<Object> internalFactory = (errors1, context, dependency) -> targetBinding.getInternalFactory().get(errors1.withSource(targetKey), context, dependency);
        return new LinkedBindingImpl<Object>(this, key, rawType, Scopes.scope(this, internalFactory, scoping), scoping, targetKey);
    }

    private <T> BindingImpl<T> createJustInTimeBindingRecursive(Key<T> key, Errors errors) throws ErrorsException {
        if (this.state.isDenylisted(key)) {
            throw errors.childBindingAlreadySet(key).toException();
        }
        BindingImpl<T> binding = this.createJustInTimeBinding(key, errors);
        this.state.parent().denylist(key);
        this.jitBindings.put(key, binding);
        return binding;
    }

    <T> BindingImpl<T> createJustInTimeBinding(Key<T> key, Errors errors) throws ErrorsException {
        if (this.state.isDenylisted(key)) {
            throw errors.childBindingAlreadySet(key).toException();
        }
        if (InjectorImpl.isSupplier(key)) {
            BindingImpl<Supplier<T>> binding = this.createSupplierBinding(key, errors);
            return binding;
        }
        if (InjectorImpl.isMembersInjector(key)) {
            BindingImpl<MembersInjector<T>> binding = this.createMembersInjectorBinding(key, errors);
            return binding;
        }
        BindingImpl<Supplier<T>> convertedBinding = this.convertConstantStringBinding(key, errors);
        if (convertedBinding != null) {
            return convertedBinding;
        }
        if (key.hasAnnotationType()) {
            if (key.hasAttributes()) {
                try {
                    Errors ignored = new Errors();
                    return this.getBindingOrThrow(key.withoutAttributes(), ignored);
                }
                catch (ErrorsException ignored) {
                    // empty catch block
                }
            }
            throw errors.missingImplementation(key).toException();
        }
        Class<Supplier<T>> source = key.getTypeLiteral().getRawType();
        BindingImpl<Supplier<T>> binding = this.createUnitializedBinding(key, Scoping.UNSCOPED, source, errors);
        this.initializeBinding(binding, errors);
        return binding;
    }

    <T> InternalFactory<? extends T> getInternalFactory(Key<T> key, Errors errors) throws ErrorsException {
        return this.getBindingOrThrow(key, errors).getInternalFactory();
    }

    SingleParameterInjector<?>[] getParametersInjectors(List<Dependency<?>> parameters, Errors errors) throws ErrorsException {
        if (parameters.isEmpty()) {
            return null;
        }
        int numErrorsBefore = errors.size();
        SingleParameterInjector[] result = new SingleParameterInjector[parameters.size()];
        int i = 0;
        for (Dependency<?> parameter : parameters) {
            try {
                result[i++] = this.createParameterInjector(parameter, errors.withSource(parameter));
            }
            catch (ErrorsException errorsException) {}
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return result;
    }

    <T> SingleParameterInjector<T> createParameterInjector(Dependency<T> dependency, Errors errors) throws ErrorsException {
        InternalFactory<T> factory = this.getInternalFactory(dependency.getKey(), errors);
        return new SingleParameterInjector<T>(dependency, factory);
    }

    @Override
    public <T> Supplier<T> getSupplier(Class<T> type) {
        return this.getSupplier(Key.get(type));
    }

    <T> Supplier<T> getSupplierOrThrow(Key<T> key, Errors errors) throws ErrorsException {
        final InternalFactory factory = this.getInternalFactory(key, errors);
        if (factory instanceof InternalFactory.Instance) {
            return () -> {
                try {
                    return factory.get(null, null, null);
                }
                catch (ErrorsException errorsException) {
                    assert (false);
                    return null;
                }
            };
        }
        final Dependency<T> dependency = Dependency.get(key);
        return new Supplier<T>(){

            @Override
            public T get() {
                Errors errors = new Errors(dependency);
                try {
                    Object t = InjectorImpl.this.callInContext(context -> {
                        context.setDependency(dependency);
                        try {
                            Object t = factory.get(errors, context, dependency);
                            return t;
                        }
                        finally {
                            context.setDependency(null);
                        }
                    });
                    errors.throwIfNewErrors(0);
                    return t;
                }
                catch (ErrorsException e) {
                    throw new ProvisionException(errors.merge(e.getErrors()).getMessages());
                }
            }

            public String toString() {
                return factory.toString();
            }
        };
    }

    @Override
    public <T> Supplier<T> getSupplier(Key<T> key) {
        Errors errors = new Errors(key);
        try {
            Supplier<T> result = this.getSupplierOrThrow(key, errors);
            errors.throwIfNewErrors(0);
            return result;
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    @Override
    public <T> T getInstance(Key<T> key) {
        return this.getSupplier(key).get();
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.getSupplier(type).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T callInContext(ContextualCallable<T> callable) throws ErrorsException {
        Object[] reference = this.localContext.get();
        if (reference == null) {
            reference = new Object[1];
            this.localContext.set(reference);
        }
        if (reference[0] == null) {
            reference[0] = new InternalContext();
            try {
                T t = callable.call((InternalContext)reference[0]);
                return t;
            }
            finally {
                reference[0] = null;
            }
        }
        return callable.call((InternalContext)reference[0]);
    }

    public String toString() {
        return new ToStringBuilder(Injector.class).add("bindings", this.state.getExplicitBindingsThisLevel().values()).toString();
    }

    public void clearCache() {
        this.state.clearDenylisted();
        this.constructors = new ConstructorInjectorStore(this);
        this.membersInjectorStore = new MembersInjectorStore(this);
        this.jitBindings = new HashMap();
    }

    public void readOnlyAllSingletons() {
        this.state.makeAllBindingsToEagerSingletons(this);
        this.bindingsMultimap = new BindingsMultimap();
        this.index();
    }

    private static class BindingsMultimap {
        final Map<TypeLiteral<?>, List<Binding<?>>> multimap = new HashMap();

        private BindingsMultimap() {
        }

        <T> void put(TypeLiteral<T> type, Binding<T> binding) {
            this.multimap.computeIfAbsent(type, k -> new ArrayList()).add(binding);
        }

        <T> List<Binding<T>> getAll(TypeLiteral<T> type) {
            List<Binding<?>> bindings = this.multimap.get(type);
            return bindings != null ? Collections.unmodifiableList(this.multimap.get(type)) : Collections.emptyList();
        }
    }

    static final class SupplierBindingImpl<T>
    extends BindingImpl<Supplier<T>>
    implements SupplierBinding<Supplier<T>> {
        final BindingImpl<T> providedBinding;

        SupplierBindingImpl(InjectorImpl injector, Key<Supplier<T>> key, Binding<T> providedBinding) {
            super(injector, key, providedBinding.getSource(), SupplierBindingImpl.createInternalFactory(providedBinding), Scoping.UNSCOPED);
            this.providedBinding = (BindingImpl)providedBinding;
        }

        static <T> InternalFactory<Supplier<T>> createInternalFactory(Binding<T> providedBinding) {
            Supplier supplier = providedBinding.getSupplier();
            return (errors, context, dependency) -> supplier;
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super Supplier<T>, V> visitor) {
            return visitor.visit();
        }

        @Override
        public String toString() {
            return new ToStringBuilder(SupplierKeyBinding.class).add("key", this.getKey()).add("providedKey", this.providedBinding.getKey()).toString();
        }
    }

    private static class ConvertedConstantBindingImpl<T>
    extends BindingImpl<T>
    implements ConvertedConstantBinding<T> {
        final T value;
        final Supplier<T> supplier;
        final Binding<String> originalBinding;

        ConvertedConstantBindingImpl(Injector injector, Key<T> key, T value, Binding<String> originalBinding) {
            super(injector, key, originalBinding.getSource(), new ConstantFactory<T>(Initializables.of(value)), Scoping.UNSCOPED);
            this.value = value;
            this.supplier = Suppliers.of(value);
            this.originalBinding = originalBinding;
        }

        @Override
        public Supplier<T> getSupplier() {
            return this.supplier;
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
            return visitor.visit();
        }

        @Override
        public String toString() {
            return new ToStringBuilder(ConvertedConstantBinding.class).add("key", this.getKey()).add("sourceKey", this.originalBinding.getKey()).add("value", this.value).toString();
        }
    }

    static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException;
    }
}

