/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.Binder;
import io.skylite.core.common.inject.BindingProcessor;
import io.skylite.core.common.inject.InheritingState;
import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.MembersInjectorStore;
import io.skylite.core.common.inject.MessageProcessor;
import io.skylite.core.common.inject.Module;
import io.skylite.core.common.inject.ScopeBindingProcessor;
import io.skylite.core.common.inject.Scopes;
import io.skylite.core.common.inject.Singleton;
import io.skylite.core.common.inject.Stage;
import io.skylite.core.common.inject.State;
import io.skylite.core.common.inject.TypeConverterBindingProcessor;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.InternalContext;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.internal.ProviderInstanceBindingImpl;
import io.skylite.core.common.inject.internal.Scoping;
import io.skylite.core.common.inject.internal.SourceProvider;
import io.skylite.core.common.inject.internal.Stopwatch;
import io.skylite.core.common.inject.spi.Dependency;
import io.skylite.core.common.inject.spi.Element;
import io.skylite.core.common.inject.spi.Elements;
import io.skylite.core.common.inject.spi.InjectionPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;

class InjectorShell {
    private final List<Element> elements;
    private final InjectorImpl injector;

    private InjectorShell(List<Element> elements, InjectorImpl injector) {
        this.elements = elements;
        this.injector = injector;
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    List<Element> getElements() {
        return this.elements;
    }

    private static void bindInjector(InjectorImpl injector) {
        Key<Injector> key = Key.get(Injector.class);
        InjectorFactory injectorFactory = new InjectorFactory(injector);
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Injector>(injector, key, SourceProvider.UNKNOWN_SOURCE, injectorFactory, Scoping.UNSCOPED, injectorFactory, Collections.emptySet()));
    }

    private static void bindLogger(InjectorImpl injector) {
        Key<Logger> key = Key.get(Logger.class);
        LoggerFactory loggerFactory = new LoggerFactory();
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Logger>(injector, key, SourceProvider.UNKNOWN_SOURCE, loggerFactory, Scoping.UNSCOPED, loggerFactory, Collections.emptySet()));
    }

    private static class InjectorFactory
    implements InternalFactory<Injector>,
    Supplier<Injector> {
        private final Injector injector;

        private InjectorFactory(Injector injector) {
            this.injector = injector;
        }

        @Override
        public Injector get(Errors errors, InternalContext context, Dependency<?> dependency) {
            return this.injector;
        }

        @Override
        public Injector get() {
            return this.injector;
        }

        public String toString() {
            return "Supplier<Injector>";
        }
    }

    private static class LoggerFactory
    implements InternalFactory<Logger>,
    Supplier<Logger> {
        private LoggerFactory() {
        }

        @Override
        public Logger get(Errors errors, InternalContext context, Dependency<?> dependency) {
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            return injectionPoint == null ? Logger.getAnonymousLogger() : Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
        }

        @Override
        public Logger get() {
            return Logger.getAnonymousLogger();
        }

        public String toString() {
            return "Supplier<Logger>";
        }
    }

    private static class RootModule
    implements Module {
        final Stage stage;

        private RootModule(Stage stage) {
            this.stage = Objects.requireNonNull(stage, "stage");
        }

        @Override
        public void configure(Binder binder) {
            binder = binder.withSource(SourceProvider.UNKNOWN_SOURCE);
            binder.bind(Stage.class).toInstance(this.stage);
            binder.bindScope(Singleton.class, Scopes.SINGLETON);
        }
    }

    static class Builder {
        private final List<Element> elements = new ArrayList<Element>();
        private final List<Module> modules = new ArrayList<Module>();
        private State state;
        private final Stage stage = Stage.DEVELOPMENT;

        Builder() {
        }

        void addModules(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                this.modules.add(module);
            }
        }

        Object lock() {
            return this.getState().lock();
        }

        List<InjectorShell> build(BindingProcessor bindingProcessor, Stopwatch stopwatch, Errors errors) {
            if (this.state == null) {
                throw new IllegalStateException("no state. Did you remember to lock() ?");
            }
            InjectorImpl injector = new InjectorImpl(this.state);
            this.modules.add(0, new RootModule(this.stage));
            new TypeConverterBindingProcessor(errors).prepareBuiltInConverters(injector);
            this.elements.addAll(Elements.getElements(this.stage, this.modules));
            stopwatch.resetAndLog("Module execution");
            new MessageProcessor(errors).process(injector, this.elements);
            injector.membersInjectorStore = new MembersInjectorStore(injector);
            stopwatch.resetAndLog("TypeListeners creation");
            new ScopeBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Scopes creation");
            new TypeConverterBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Converters creation");
            InjectorShell.bindInjector(injector);
            InjectorShell.bindLogger(injector);
            bindingProcessor.process(injector, this.elements);
            stopwatch.resetAndLog("Binding creation");
            ArrayList<InjectorShell> injectorShells = new ArrayList<InjectorShell>();
            injectorShells.add(new InjectorShell(this.elements, injector));
            stopwatch.resetAndLog("Private environment creation");
            return injectorShells;
        }

        private State getState() {
            if (this.state == null) {
                this.state = new InheritingState();
            }
            return this.state;
        }
    }
}

