/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.Initializable;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.InternalContext;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.internal.SourceProvider;
import io.skylite.core.common.inject.spi.Dependency;
import java.util.Objects;
import java.util.function.Supplier;

class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Initializable<Supplier<? extends T>> initializable;
    private final Object source;

    InternalFactoryToProviderAdapter(Initializable<Supplier<? extends T>> initializable) {
        this(initializable, SourceProvider.UNKNOWN_SOURCE);
    }

    InternalFactoryToProviderAdapter(Initializable<Supplier<? extends T>> initializable, Object source) {
        this.initializable = Objects.requireNonNull(initializable, "provider");
        this.source = Objects.requireNonNull(source, "source");
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
        try {
            return errors.checkForNull(this.initializable.get(errors).get(), this.source, dependency);
        }
        catch (RuntimeException userException) {
            throw errors.withSource(this.source).errorInSupplier(userException).toException();
        }
    }

    public String toString() {
        return this.initializable.toString();
    }
}

