/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.Initializables;
import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.InternalFactoryToProviderAdapter;
import io.skylite.core.common.inject.Scope;
import io.skylite.core.common.inject.SupplierToInternalFactoryAdapter;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.internal.Scoping;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.function.Supplier;

public class Scopes {
    public static final Scope SINGLETON = new Scope(){

        @Override
        public <T> Supplier<T> scope(final Supplier<T> creator) {
            return new Supplier<T>(this){
                private volatile T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public T get() {
                    if (this.instance != null) return this.instance;
                    Class<InjectorImpl> clazz = InjectorImpl.class;
                    synchronized (InjectorImpl.class) {
                        if (this.instance != null) return this.instance;
                        this.instance = creator.get();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return this.instance;
                    }
                }

                public String toString() {
                    return String.format(Locale.ROOT, "%s[%s]", creator, SINGLETON);
                }
            };
        }

        @Override
        public String toString() {
            return "Scopes.SINGLETON";
        }
    };
    public static final Scope NO_SCOPE = new Scope(){

        @Override
        public <T> Supplier<T> scope(Supplier<T> unscoped) {
            return unscoped;
        }

        @Override
        public String toString() {
            return "Scopes.NO_SCOPE";
        }
    };

    private Scopes() {
    }

    static <T> InternalFactory<? extends T> scope(InjectorImpl injector, InternalFactory<? extends T> creator, Scoping scoping) {
        if (scoping.isNoScope()) {
            return creator;
        }
        Scope scope = scoping.getScopeInstance();
        Supplier<? extends T> scoped = scope.scope(new SupplierToInternalFactoryAdapter<T>(injector, creator));
        return new InternalFactoryToProviderAdapter<T>(Initializables.of(scoped));
    }

    static Scoping makeInjectable(Scoping scoping, InjectorImpl injector, Errors errors) {
        Class<? extends Annotation> scopeAnnotation = scoping.getScopeAnnotation();
        if (scopeAnnotation == null) {
            return scoping;
        }
        Scope scope = injector.state.getScope(scopeAnnotation);
        if (scope != null) {
            return Scoping.forInstance(scope);
        }
        errors.scopeNotFound(scopeAnnotation);
        return Scoping.UNSCOPED;
    }
}

