/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.SingleMemberInjector;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.InternalContext;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.spi.Dependency;
import io.skylite.core.common.inject.spi.InjectionPoint;
import java.lang.reflect.Field;

class SingleFieldInjector
implements SingleMemberInjector {
    final Field field;
    final InjectionPoint injectionPoint;
    final Dependency<?> dependency;
    final InternalFactory<?> factory;

    SingleFieldInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        this.field = (Field)injectionPoint.getMember();
        this.dependency = injectionPoint.getDependencies().get(0);
        this.factory = injector.getInternalFactory(this.dependency.getKey(), errors);
    }

    @Override
    public void inject(Errors errors, InternalContext context, Object o) {
        errors = errors.withSource(this.dependency);
        context.setDependency(this.dependency);
        try {
            Object value = this.factory.get(errors, context, this.dependency);
            this.field.set(o, value);
        }
        catch (ErrorsException e) {
            errors.withSource(this.injectionPoint).merge(e.getErrors());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            context.setDependency(null);
        }
    }
}

