/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject;

import io.skylite.core.common.inject.InjectorImpl;
import io.skylite.core.common.inject.ProvisionException;
import io.skylite.core.common.inject.internal.Errors;
import io.skylite.core.common.inject.internal.ErrorsException;
import io.skylite.core.common.inject.internal.InternalFactory;
import io.skylite.core.common.inject.spi.Dependency;
import java.util.function.Supplier;

class SupplierToInternalFactoryAdapter<T>
implements Supplier<T> {
    private final InjectorImpl injector;
    private final InternalFactory<? extends T> internalFactory;

    SupplierToInternalFactoryAdapter(InjectorImpl injector, InternalFactory<? extends T> internalFactory) {
        this.injector = injector;
        this.internalFactory = internalFactory;
    }

    @Override
    public T get() {
        Errors errors = new Errors();
        try {
            Object t = this.injector.callInContext(context -> {
                Dependency dependency = context.getDependency();
                return this.internalFactory.get(errors, context, dependency);
            });
            errors.throwIfNewErrors(0);
            return (T)t;
        }
        catch (ErrorsException e) {
            throw new ProvisionException(errors.merge(e.getErrors()).getMessages());
        }
    }

    public String toString() {
        return this.internalFactory.toString();
    }
}

