/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.multibindings;

import io.skylite.core.common.inject.Binder;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.Module;
import io.skylite.core.common.inject.TypeLiteral;
import io.skylite.core.common.inject.binder.LinkedBindingBuilder;
import io.skylite.core.common.inject.multibindings.Multibinder;
import io.skylite.core.common.inject.multibindings.RealElement;
import io.skylite.core.common.inject.spi.SupplierWithDependencies;
import io.skylite.core.common.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public abstract class MapBinder<K, V> {
    private MapBinder() {
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> keyType, Class<V> valueType) {
        TypeLiteral<K> keyTypeLocal = TypeLiteral.get(keyType);
        TypeLiteral<V> valueTypeLocal = TypeLiteral.get(valueType);
        return MapBinder.newMapBinder(binder.skipSources(MapBinder.class, RealMapBinder.class), valueTypeLocal, Key.get(MapBinder.mapOf(keyTypeLocal, valueTypeLocal)), Key.get(MapBinder.mapOfProviderOf(keyTypeLocal, valueTypeLocal)), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(keyTypeLocal, valueTypeLocal)));
    }

    private static <K, V> TypeLiteral<Map<K, V>> mapOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), valueType.getType()));
    }

    private static <K, V> TypeLiteral<Map<K, Supplier<V>>> mapOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), Types.newParameterizedType(Supplier.class, new Type[]{valueType.getType()})));
    }

    private static <K, V> TypeLiteral<Map.Entry<K, Supplier<V>>> entryOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, new Type[]{keyType.getType(), Types.providerOf(valueType.getType())}));
    }

    private static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<V> valueType, Key<Map<K, V>> mapKey, Key<Map<K, Supplier<V>>> providerMapKey, Multibinder<Map.Entry<K, Supplier<V>>> entrySetBinder) {
        RealMapBinder<K, V> mapBinder = new RealMapBinder<K, V>(binder, valueType, mapKey, providerMapKey, entrySetBinder);
        binder.install(mapBinder);
        return mapBinder;
    }

    public abstract LinkedBindingBuilder<V> addBinding(K var1);

    public static final class RealMapBinder<K, V>
    extends MapBinder<K, V>
    implements Module {
        private final TypeLiteral<V> valueType;
        private final Key<Map<K, V>> mapKey;
        private final Key<Map<K, Supplier<V>>> providerMapKey;
        private final Multibinder.RealMultibinder<Map.Entry<K, Supplier<V>>> entrySetBinder;
        private Binder binder;

        private RealMapBinder(Binder binder, TypeLiteral<V> valueType, Key<Map<K, V>> mapKey, Key<Map<K, Supplier<V>>> providerMapKey, Multibinder<Map.Entry<K, Supplier<V>>> entrySetBinder) {
            this.valueType = valueType;
            this.mapKey = mapKey;
            this.providerMapKey = providerMapKey;
            this.entrySetBinder = (Multibinder.RealMultibinder)entrySetBinder;
            this.binder = binder;
        }

        @Override
        public LinkedBindingBuilder<V> addBinding(K key) {
            Multibinder.checkNotNull(key, "key");
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            Key<V> valueKey = Key.get(this.valueType, new RealElement(this.entrySetBinder.getSetName()));
            this.entrySetBinder.addBinding().toInstance(new MapEntry<K, Supplier<V>>(key, this.binder.getSupplier(valueKey)));
            return this.binder.bind(valueKey);
        }

        @Override
        public void configure(Binder binder) {
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            Supplier<Set<Map.Entry<K, Supplier<V>>>> entrySetProvider = binder.getSupplier(this.entrySetBinder.getSetKey());
            binder.bind(this.providerMapKey).toSupplier(new MapBinderSupplierWithDependencies<K, V>(this, entrySetProvider));
            Supplier mapProvider = binder.getSupplier(this.providerMapKey);
            binder.bind(this.mapKey).toSupplier(() -> {
                LinkedHashMap map = new LinkedHashMap();
                for (Map.Entry entry : ((Map)mapProvider.get()).entrySet()) {
                    Object value = ((Supplier)entry.getValue()).get();
                    Object key = entry.getKey();
                    Multibinder.checkConfiguration(value != null, "Map injection failed due to null value for key \"%s\"", key);
                    map.put(key, value);
                }
                return Collections.unmodifiableMap(map);
            });
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public boolean equals(Object o) {
            return o instanceof RealMapBinder && ((RealMapBinder)o).mapKey.equals(this.mapKey);
        }

        public int hashCode() {
            return this.mapKey.hashCode();
        }

        private static final class MapEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private final V value;

            private MapEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof Map.Entry && this.key.equals(((Map.Entry)obj).getKey()) && this.value.equals(((Map.Entry)obj).getValue());
            }

            @Override
            public int hashCode() {
                return 127 * ("key".hashCode() ^ this.key.hashCode()) + 127 * ("value".hashCode() ^ this.value.hashCode());
            }

            public String toString() {
                return "MapEntry(" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ")";
            }
        }

        public static class MapBinderSupplierWithDependencies<K, V>
        implements SupplierWithDependencies<Map<K, Supplier<V>>> {
            private Map<K, Supplier<V>> supplierMap;
            private final RealMapBinder binder;
            private final Supplier<Set<Map.Entry<K, Supplier<V>>>> supplier;

            MapBinderSupplierWithDependencies(RealMapBinder binder, Supplier<Set<Map.Entry<K, Supplier<V>>>> supplier) {
                this.binder = binder;
                this.supplier = supplier;
            }

            @Inject
            public void initialize() {
                this.binder.binder = null;
                LinkedHashMap<K, Supplier<V>> providerMapMutable = new LinkedHashMap<K, Supplier<V>>();
                for (Map.Entry<K, Supplier<V>> entry : this.supplier.get()) {
                    Multibinder.checkConfiguration(providerMapMutable.put(entry.getKey(), entry.getValue()) == null, "Map injection failed due to duplicated key \"%s\"", entry.getKey());
                }
                this.supplierMap = Collections.unmodifiableMap(providerMapMutable);
            }

            @Override
            public Map<K, Supplier<V>> get() {
                return this.supplierMap;
            }
        }
    }
}

