/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.inject.spi;

import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.spi.Element;
import io.skylite.core.common.inject.spi.ElementVisitor;
import java.util.Objects;
import java.util.function.Supplier;

public final class SupplierLookup<T>
implements Element {
    private final Object source;
    private final Key<T> key;
    private Supplier<T> delegate;

    public SupplierLookup(Object source, Key<T> key) {
        this.source = Objects.requireNonNull(source, "source");
        this.key = Objects.requireNonNull(key, "key");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public void initializeDelegate(Supplier<T> delegate) {
        if (this.delegate != null) {
            throw new IllegalStateException("delegate already initialized");
        }
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public Supplier<T> getSupplier() {
        return new SupplierImpl(this);
    }

    public static class SupplierImpl<T>
    implements Supplier<T> {
        private final SupplierLookup<T> lookup;

        private SupplierImpl(SupplierLookup<T> lookup) {
            this.lookup = lookup;
        }

        @Override
        public T get() {
            if (this.lookup.delegate == null) {
                throw new IllegalStateException("This Provider cannot be used until the Injector has been created.");
            }
            return this.lookup.delegate.get();
        }

        public String toString() {
            return "Provider<" + String.valueOf(this.lookup.key.getTypeLiteral()) + ">";
        }
    }
}

