/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.io;

import io.skylite.core.common.io.IndexIOStreamHandler;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class VersionedCodecStreamWrapper<T> {
    private static final Logger logger = LogManager.getLogger(VersionedCodecStreamWrapper.class);
    private final IndexIOStreamHandler<T> indexIOStreamHandler;
    private final int currentVersion;
    private final String codec;

    public VersionedCodecStreamWrapper(IndexIOStreamHandler<T> indexIOStreamHandler, int currentVersion, String codec) {
        this.indexIOStreamHandler = indexIOStreamHandler;
        this.currentVersion = currentVersion;
        this.codec = codec;
    }

    public T readStream(IndexInput indexInput) throws IOException {
        logger.debug("Reading input stream [{}] of length - [{}]", (Object)indexInput.toString(), (Object)indexInput.length());
        try {
            CodecUtil.checksumEntireFile((IndexInput)indexInput);
            int readStreamVersion = this.checkHeader(indexInput);
            return this.getHandlerForVersion(readStreamVersion).readContent(indexInput);
        }
        catch (CorruptIndexException cie) {
            logger.error(() -> new ParameterizedMessage("Error while validating header/footer for [{}]. Total data length [{}]", (Object)indexInput.toString(), (Object)indexInput.length()));
            throw cie;
        }
    }

    public void writeStream(IndexOutput indexOutput, T content) throws IOException {
        this.writeHeader(indexOutput);
        this.getHandlerForVersion(this.currentVersion).writeContent(indexOutput, content);
        this.writeFooter(indexOutput);
    }

    private int checkHeader(IndexInput indexInput) throws IOException {
        return CodecUtil.checkHeader((DataInput)indexInput, (String)this.codec, (int)this.currentVersion, (int)this.currentVersion);
    }

    private void checkFooter(ChecksumIndexInput indexInput) throws IOException {
        CodecUtil.checkFooter((ChecksumIndexInput)indexInput);
    }

    private void writeHeader(IndexOutput indexOutput) throws IOException {
        CodecUtil.writeHeader((DataOutput)indexOutput, (String)this.codec, (int)this.currentVersion);
    }

    private void writeFooter(IndexOutput indexOutput) throws IOException {
        CodecUtil.writeFooter((IndexOutput)indexOutput);
    }

    private IndexIOStreamHandler<T> getHandlerForVersion(int version) {
        return this.indexIOStreamHandler;
    }
}

