/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.io.stream;

import io.skylite.common.annotation.PublicApi;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.Writeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@PublicApi(since="1.0.0")
public class NamedWriteableRegistry {
    private final Map<Class<?>, Map<String, Writeable.Reader<?>>> registry;

    public NamedWriteableRegistry(List<Entry> entries) {
        if (entries.isEmpty()) {
            this.registry = Collections.emptyMap();
            return;
        }
        entries = new ArrayList<Entry>(entries);
        entries.sort(Comparator.comparing(e -> e.categoryClass.getName()));
        HashMap registry = new HashMap();
        HashMap readers = null;
        Class<?> currentCategory = null;
        for (Entry entry : entries) {
            Writeable.Reader<?> oldReader;
            if (currentCategory != entry.categoryClass) {
                if (currentCategory != null) {
                    registry.put(currentCategory, Collections.unmodifiableMap(readers));
                }
                readers = new HashMap();
                currentCategory = entry.categoryClass;
            }
            if ((oldReader = readers.put(entry.name, entry.reader)) == null) continue;
            throw new IllegalArgumentException("NamedWriteable [" + currentCategory.getName() + "][" + entry.name + "] is already registered for [" + oldReader.getClass().getName() + "], cannot register [" + entry.reader.getClass().getName() + "]");
        }
        registry.put(currentCategory, Collections.unmodifiableMap(readers));
        this.registry = Collections.unmodifiableMap(registry);
    }

    public <T> Writeable.Reader<? extends T> getReader(Class<T> categoryClass, String name) {
        Map<String, Writeable.Reader<?>> readers = this.registry.get(categoryClass);
        if (readers == null) {
            throw new IllegalArgumentException("Unknown NamedWriteable category [" + categoryClass.getName() + "]");
        }
        Writeable.Reader<?> reader = readers.get(name);
        if (reader == null) {
            throw new IllegalArgumentException("Unknown NamedWriteable [" + categoryClass.getName() + "][" + name + "]");
        }
        return reader;
    }

    @PublicApi(since="1.0.0")
    public static class Entry {
        public final Class<?> categoryClass;
        public final String name;
        public final Writeable.Reader<?> reader;

        public <T extends NamedWriteable> Entry(Class<T> categoryClass, String name, Writeable.Reader<? extends T> reader) {
            this.categoryClass = Objects.requireNonNull(categoryClass);
            this.name = Objects.requireNonNull(name);
            this.reader = Objects.requireNonNull(reader);
        }
    }
}

