/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.io.stream;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;

public final class NotSerializableExceptionWrapper
extends SkyliteException {
    private final String name;
    private final RestStatus status;

    public NotSerializableExceptionWrapper(Throwable other) {
        super(SkyliteException.getExceptionName(other) + ": " + other.getMessage(), other.getCause(), new Object[0]);
        this.name = SkyliteException.getExceptionName(other);
        this.status = SkyliteExceptionsHelper.status(other);
        this.setStackTrace(other.getStackTrace());
        for (Throwable otherSuppressed : other.getSuppressed()) {
            this.addSuppressed(otherSuppressed);
        }
        if (other instanceof SkyliteException) {
            SkyliteException ex = (SkyliteException)other;
            for (String key : ex.getHeaderKeys()) {
                this.addHeader(key, ex.getHeader(key));
            }
            for (String key : ex.getMetadataKeys()) {
                this.addMetadata(key, ex.getMetadata(key));
            }
        }
    }

    public NotSerializableExceptionWrapper(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        RestStatus.writeTo(out, this.status);
    }

    @Override
    protected String getExceptionName() {
        return this.name;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    public static class Registration
    implements SkyliteExceptionProvider<NotSerializableExceptionWrapper> {
        @Override
        public Class<NotSerializableExceptionWrapper> getExceptionClass() {
            return NotSerializableExceptionWrapper.class;
        }

        @Override
        public CheckedFunction<StreamInput, NotSerializableExceptionWrapper, IOException> getConstructor() {
            return NotSerializableExceptionWrapper::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 62;
        }
    }
}

