/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.logging;

import io.skylite.common.collect.MapBuilder;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.SkyliteLogMessage;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DeprecatedMessage
extends SkyliteLogMessage {
    private static final Set<String> keys = ConcurrentHashMap.newKeySet();
    private final String keyWithXOpaqueId;

    public DeprecatedMessage(String key, String xOpaqueId, String messagePattern, Object ... args) {
        super(DeprecatedMessage.fieldMap(key, xOpaqueId), messagePattern, args);
        this.keyWithXOpaqueId = key + xOpaqueId;
    }

    public static void resetDeprecatedMessageForTests() {
        keys.clear();
    }

    private static Map<String, Object> fieldMap(String key, String xOpaqueId) {
        MapBuilder builder = MapBuilder.newMapBuilder();
        if (!Strings.isNullOrEmpty(key)) {
            builder.put((Object)"key", (Object)key);
        }
        if (!Strings.isNullOrEmpty(xOpaqueId)) {
            builder.put((Object)"x-opaque-id", (Object)xOpaqueId);
        }
        return builder.immutableMap();
    }

    public boolean isAlreadyLogged() {
        return !keys.add(this.keyWithXOpaqueId);
    }
}

