/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.logging;

import io.skylite.common.SetOnce;
import java.util.Arrays;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(category="Converter", name="NodeNamePatternConverter")
@ConverterKeys(value={"node_name"})
public final class NodeNamePatternConverter
extends LogEventPatternConverter {
    private static final SetOnce<String> NODE_NAME = new SetOnce();
    private final String nodeName;

    static void setNodeName(String nodeName) {
        NODE_NAME.set((Object)nodeName);
    }

    public static NodeNamePatternConverter newInstance(String[] options) {
        if (options.length > 0) {
            throw new IllegalArgumentException("no options supported but options provided: " + Arrays.toString(options));
        }
        String nodeName = (String)NODE_NAME.get();
        if (nodeName == null) {
            throw new IllegalStateException("the node name hasn't been set");
        }
        return new NodeNamePatternConverter(nodeName);
    }

    private NodeNamePatternConverter(String nodeName) {
        super("NodeName", "node_name");
        this.nodeName = nodeName;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        toAppendTo.append(this.nodeName);
    }
}

