/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.logging;

import io.skylite.core.common.logging.SkyliteLogMessage;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="RateLimitingFilter", category="Core", elementType="filter")
public class RateLimitingFilter
extends AbstractFilter {
    private final Set<String> lruKeyCache = Collections.newSetFromMap(Collections.synchronizedMap(new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 128;
        }
    }));

    public RateLimitingFilter() {
        this(Filter.Result.ACCEPT, Filter.Result.DENY);
    }

    public RateLimitingFilter(Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
    }

    public void reset() {
        this.lruKeyCache.clear();
    }

    public Filter.Result filter(Message message) {
        if (message instanceof SkyliteLogMessage) {
            String key;
            SkyliteLogMessage skyliteLogMessage = (SkyliteLogMessage)message;
            String xOpaqueId = skyliteLogMessage.getValueFor("x-opaque-id");
            return this.lruKeyCache.add(xOpaqueId + (key = skyliteLogMessage.getValueFor("key"))) ? Filter.Result.ACCEPT : Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(LogEvent event) {
        return this.filter(event.getMessage());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter(msg);
    }

    @PluginFactory
    public static RateLimitingFilter createFilter(@PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch) {
        return new RateLimitingFilter(match, mismatch);
    }
}

