/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.logging;

import io.skylite.core.common.Strings;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="SkyliteJsonLayout", category="Core", elementType="layout", printObject=true)
public class SkyliteJsonLayout
extends AbstractStringLayout {
    private final PatternLayout patternLayout;

    protected SkyliteJsonLayout(String typeName, Charset charset, String[] luceniaMessageFields, int maxMessageLength, Configuration configuration) {
        super(charset);
        this.patternLayout = PatternLayout.newBuilder().withPattern(this.pattern(typeName, luceniaMessageFields, maxMessageLength)).withAlwaysWriteExceptions(false).withConfiguration(configuration).build();
    }

    private String pattern(String type, String[] luceniaMessageFields, int maxMessageLength) {
        if (Strings.isEmpty(type)) {
            throw new IllegalArgumentException("layout parameter 'type_name' cannot be empty");
        }
        Object messageFormat = "%m";
        if (maxMessageLength < 0) {
            throw new IllegalArgumentException("layout parameter 'maxmessagelength' cannot be a negative number");
        }
        if (maxMessageLength > 0) {
            messageFormat = "%.-" + Integer.toString(maxMessageLength) + "m";
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", this.inQuotes(type));
        map.put("timestamp", this.inQuotes("%d{yyyy-MM-dd'T'HH:mm:ss,SSSZZ}"));
        map.put("level", this.inQuotes("%p"));
        map.put("component", this.inQuotes("%c{1.}"));
        map.put("cluster.name", this.inQuotes("${sys:lucenia.logs.cluster_name}"));
        map.put("node.name", this.inQuotes("%node_name"));
        map.put("message", this.inQuotes("%notEmpty{%enc{%marker}{JSON} }%enc{" + (String)messageFormat + "}{JSON}"));
        for (String key : luceniaMessageFields) {
            map.put(key, this.inQuotes("%SkyliteMessageField{" + key + "}"));
        }
        return this.createPattern(map, Stream.of(luceniaMessageFields).collect(Collectors.toSet()));
    }

    private String createPattern(Map<String, Object> map, Set<String> luceniaMessageFields) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String separator = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (luceniaMessageFields.contains(entry.getKey())) {
                sb.append("%notEmpty{");
                sb.append(separator);
                this.appendField(sb, entry);
                sb.append("}");
            } else {
                sb.append(separator);
                this.appendField(sb, entry);
            }
            separator = ", ";
        }
        sb.append(this.notEmpty(", %node_and_cluster_id "));
        sb.append("%exceptionAsJson ");
        sb.append("}");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private void appendField(StringBuilder sb, Map.Entry<String, Object> entry) {
        sb.append(this.jsonKey(entry.getKey()));
        sb.append(entry.getValue().toString());
    }

    private String notEmpty(String value) {
        return "%notEmpty{" + value + "}";
    }

    private CharSequence jsonKey(String s) {
        return this.inQuotes(s) + ": ";
    }

    private String inQuotes(String s) {
        return "\"" + s + "\"";
    }

    @PluginFactory
    public static SkyliteJsonLayout createLayout(String type, Charset charset, String[] luceniamessagefields, int maxMessageLength, Configuration configuration) {
        return new SkyliteJsonLayout(type, charset, luceniamessagefields, maxMessageLength, configuration);
    }

    public PatternLayout getPatternLayout() {
        return this.patternLayout;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public String toSerializable(LogEvent event) {
        return this.patternLayout.toSerializable(event);
    }

    public Map<String, String> getContentFormat() {
        return this.patternLayout.getContentFormat();
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        this.patternLayout.encode(event, destination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SkyliteJsonLayout{");
        sb.append("patternLayout=").append(this.patternLayout);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<SkyliteJsonLayout> {
        @PluginAttribute(value="type_name")
        String type;
        @PluginAttribute(value="charset", defaultString="UTF-8")
        Charset charset;
        @PluginAttribute(value="luceniamessagefields")
        private String luceniaMessageFields;
        @PluginAttribute(value="maxmessagelength", defaultInt=10000)
        private int maxMessageLength;
        @PluginConfiguration
        private Configuration configuration;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
            this.setMaxMessageLength(10000);
        }

        public SkyliteJsonLayout build() {
            String[] split = Strings.isNullOrEmpty(this.luceniaMessageFields) ? new String[]{} : this.luceniaMessageFields.split(",");
            return SkyliteJsonLayout.createLayout(this.type, this.charset, split, this.maxMessageLength, this.configuration);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public B setCharset(Charset charset) {
            this.charset = charset;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getType() {
            return this.type;
        }

        public B setType(String type) {
            this.type = type;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getLuceniaMessageFields() {
            return this.luceniaMessageFields;
        }

        public B setLuceniaMessageFields(String luceniaMessageFields) {
            this.luceniaMessageFields = luceniaMessageFields;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public int getMaxMessageLength() {
            return this.maxMessageLength;
        }

        public B setMaxMessageLength(int maxMessageLength) {
            this.maxMessageLength = maxMessageLength;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public B setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

