/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.logging;

import io.skylite.common.SuppressLoggerChecks;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;

@SuppressLoggerChecks(reason="Safe as this is abstract class")
public abstract class SkyliteLogMessage
extends ParameterizedMessage {
    private final Map<String, Object> fields;

    public SkyliteLogMessage(Map<String, Object> fields, String messagePattern, Object ... args) {
        super(messagePattern, args);
        this.fields = fields;
    }

    public String getValueFor(String key) {
        Object value = this.fields.get(key);
        return value != null ? value.toString() : null;
    }

    public static String inQuotes(String s) {
        if (s == null) {
            return SkyliteLogMessage.inQuotes("");
        }
        return "\"" + s + "\"";
    }

    public static String inQuotes(Object s) {
        if (s == null) {
            return SkyliteLogMessage.inQuotes("");
        }
        return SkyliteLogMessage.inQuotes(s.toString());
    }

    public static String asJsonArray(Stream<String> stream) {
        return "[" + stream.map(SkyliteLogMessage::inQuotes).collect(Collectors.joining(", ")) + "]";
    }

    public Object[] getArguments() {
        return super.getParameters();
    }

    public String getMessagePattern() {
        return super.getFormat();
    }
}

