/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.transport;

import io.skylite.common.network.InetAddresses;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.transport.TransportAddress;
import java.io.IOException;

public class BoundTransportAddress
implements Writeable {
    private TransportAddress[] boundAddresses;
    private TransportAddress publishAddress;

    public BoundTransportAddress(StreamInput in) throws IOException {
        int boundAddressLength = in.readInt();
        this.boundAddresses = new TransportAddress[boundAddressLength];
        for (int i = 0; i < boundAddressLength; ++i) {
            this.boundAddresses[i] = new TransportAddress(in);
        }
        this.publishAddress = new TransportAddress(in);
    }

    public BoundTransportAddress(TransportAddress[] boundAddresses, TransportAddress publishAddress) {
        if (boundAddresses == null || boundAddresses.length < 1) {
            throw new IllegalArgumentException("at least one bound address must be provided");
        }
        this.boundAddresses = boundAddresses;
        this.publishAddress = publishAddress;
    }

    public TransportAddress[] boundAddresses() {
        return this.boundAddresses;
    }

    public TransportAddress publishAddress() {
        return this.publishAddress;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.boundAddresses.length);
        for (TransportAddress address : this.boundAddresses) {
            address.writeTo(out);
        }
        this.publishAddress.writeTo(out);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("publish_address {");
        String hostString = this.publishAddress.address().getHostString();
        Object publishAddressString = this.publishAddress.toString();
        if (!InetAddresses.isInetAddress((String)hostString)) {
            publishAddressString = hostString + "/" + this.publishAddress.toString();
        }
        builder.append((String)publishAddressString);
        builder.append("}, bound_addresses ");
        boolean firstAdded = false;
        for (TransportAddress address : this.boundAddresses) {
            if (firstAdded) {
                builder.append(", ");
            } else {
                firstAdded = true;
            }
            builder.append("{").append(address).append("}");
        }
        return builder.toString();
    }
}

