/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.unit;

import io.skylite.SkyliteParseException;
import io.skylite.core.ParseField;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

public final class Fuzziness
implements ToXContentFragment,
Writeable {
    public static final String X_FIELD_NAME = "fuzziness";
    public static final Fuzziness ZERO = new Fuzziness("0");
    public static final Fuzziness ONE = new Fuzziness("1");
    public static final Fuzziness TWO = new Fuzziness("2");
    public static final Fuzziness AUTO = new Fuzziness("AUTO");
    public static final ParseField FIELD = new ParseField("fuzziness", new String[0]);
    static final int DEFAULT_LOW_DISTANCE = 3;
    static final int DEFAULT_HIGH_DISTANCE = 6;
    private final String fuzziness;
    private int lowDistance = 3;
    private int highDistance = 6;

    private Fuzziness(String fuzziness) {
        if (fuzziness == null || fuzziness.isEmpty()) {
            throw new IllegalArgumentException("fuzziness can't be null!");
        }
        this.fuzziness = fuzziness.toUpperCase(Locale.ROOT);
    }

    public Fuzziness(StreamInput in) throws IOException {
        this.fuzziness = in.readString();
        if (in.readBoolean()) {
            this.lowDistance = in.readVInt();
            this.highDistance = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fuzziness);
        if (this.isAutoWithCustomValues()) {
            out.writeBoolean(true);
            out.writeVInt(this.lowDistance);
            out.writeVInt(this.highDistance);
        } else {
            out.writeBoolean(false);
        }
    }

    public static Fuzziness fromEdits(int edits) {
        switch (edits) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
        }
        throw new IllegalArgumentException("Valid edit distances are [0, 1, 2] but was [" + edits + "]");
    }

    public static Fuzziness fromString(String fuzzinessString) {
        if (Strings.isEmpty(fuzzinessString)) {
            throw new IllegalArgumentException("fuzziness cannot be null or empty.");
        }
        String upperCase = fuzzinessString.toUpperCase(Locale.ROOT);
        if (upperCase.equals("AUTO")) {
            return AUTO;
        }
        if (upperCase.startsWith("AUTO:")) {
            return Fuzziness.parseCustomAuto(upperCase);
        }
        try {
            float parsedFloat = Float.parseFloat(upperCase);
            if (parsedFloat % 1.0f > 0.0f) {
                throw new IllegalArgumentException("fuzziness needs to be one of 0.0, 1.0 or 2.0 but was " + parsedFloat);
            }
            return Fuzziness.fromEdits((int)parsedFloat);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("fuzziness cannot be [" + fuzzinessString + "].", e);
        }
    }

    public static Fuzziness customAuto(int lowDistance, int highDistance) {
        Fuzziness fuzziness = new Fuzziness("AUTO");
        fuzziness.lowDistance = lowDistance;
        fuzziness.highDistance = highDistance;
        return fuzziness;
    }

    private static Fuzziness parseCustomAuto(String string) {
        assert (string.toUpperCase(Locale.ROOT).startsWith(AUTO.asString() + ":"));
        String[] fuzzinessLimit = string.substring(AUTO.asString().length() + 1).split(",");
        if (fuzzinessLimit.length == 2) {
            try {
                int lowerLimit = Integer.parseInt(fuzzinessLimit[0]);
                int highLimit = Integer.parseInt(fuzzinessLimit[1]);
                if (lowerLimit < 0 || highLimit < 0 || lowerLimit > highLimit) {
                    throw new SkyliteParseException("fuzziness wrongly configured [{}]. Must be 0 < lower value <= higher value.", string);
                }
                Fuzziness fuzziness = new Fuzziness("AUTO");
                fuzziness.lowDistance = lowerLimit;
                fuzziness.highDistance = highLimit;
                return fuzziness;
            }
            catch (NumberFormatException e) {
                throw new SkyliteParseException("failed to parse [{}] as a \"auto:int,int\"", (Throwable)e, string);
            }
        }
        throw new SkyliteParseException("failed to find low and high distance values", new Object[0]);
    }

    public static Fuzziness parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        switch (token) {
            case VALUE_STRING: {
                return Fuzziness.fromString(parser.text());
            }
            case VALUE_NUMBER: {
                return Fuzziness.fromEdits(parser.intValue());
            }
        }
        throw new IllegalArgumentException("Can't parse fuzziness on token: [" + String.valueOf((Object)token) + "]");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(X_FIELD_NAME, this.asString());
        return builder;
    }

    public int asDistance() {
        return this.asDistance(null);
    }

    public int asDistance(String text) {
        if (this.equals(AUTO) || this.isAutoWithCustomValues()) {
            int len = this.termLen(text);
            if (len < this.lowDistance) {
                return 0;
            }
            if (len < this.highDistance) {
                return 1;
            }
            return 2;
        }
        return Math.min(2, (int)this.asFloat());
    }

    public float asFloat() {
        if (this.equals(AUTO) || this.isAutoWithCustomValues()) {
            return 1.0f;
        }
        return Float.parseFloat(this.fuzziness);
    }

    private int termLen(String text) {
        return text == null ? 5 : text.codePointCount(0, text.length());
    }

    public String asString() {
        if (this.isAutoWithCustomValues()) {
            return this.fuzziness + ":" + this.lowDistance + "," + this.highDistance;
        }
        return this.fuzziness;
    }

    private boolean isAutoWithCustomValues() {
        return this.fuzziness.startsWith("AUTO") && (this.lowDistance != 3 || this.highDistance != 6);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fuzziness other = (Fuzziness)obj;
        return Objects.equals(this.fuzziness, other.fuzziness) && this.lowDistance == other.lowDistance && this.highDistance == other.highDistance;
    }

    public int hashCode() {
        return Objects.hash(this.fuzziness, this.lowDistance, this.highDistance);
    }
}

