/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.unit;

import io.skylite.SkyliteParseException;

public class RatioValue {
    private final double percent;

    public RatioValue(double percent) {
        this.percent = percent;
    }

    public double getAsRatio() {
        return this.percent / 100.0;
    }

    public double getAsPercent() {
        return this.percent;
    }

    public String toString() {
        return this.percent + "%";
    }

    public static RatioValue parseRatioValue(String sValue) {
        if (sValue.endsWith("%")) {
            String percentAsString = sValue.substring(0, sValue.length() - 1);
            try {
                double percent = Double.parseDouble(percentAsString);
                if (percent < 0.0 || percent > 100.0) {
                    throw new SkyliteParseException("Percentage should be in [0-100], got [{}]", percentAsString);
                }
                return new RatioValue(Math.abs(percent));
            }
            catch (NumberFormatException e) {
                throw new SkyliteParseException("Failed to parse [{}] as a double", (Throwable)e, percentAsString);
            }
        }
        try {
            double ratio = Double.parseDouble(sValue);
            if (ratio < 0.0 || ratio > 1.0) {
                throw new SkyliteParseException("Ratio should be in [0-1.0], got [{}]", ratio);
            }
            return new RatioValue(100.0 * Math.abs(ratio));
        }
        catch (NumberFormatException e) {
            throw new SkyliteParseException("Invalid ratio or percentage [{}]", sValue);
        }
    }
}

