/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.util;

import io.skylite.core.common.util.AbstractBigArray;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.ObjectArray;
import io.skylite.core.common.util.PageCacheRecycler;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

final class BigObjectArray<T>
extends AbstractBigArray
implements ObjectArray<T> {
    private static final BigObjectArray<Long> ESTIMATOR = new BigObjectArray(0L, BigArrays.NON_RECYCLING_INSTANCE);
    private Object[][] pages;

    BigObjectArray(long size, BigArrays bigArrays) {
        super(PageCacheRecycler.OBJECT_PAGE_SIZE, bigArrays, true);
        this.size = size;
        this.pages = new Object[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newObjectPage(i);
        }
    }

    @Override
    public T get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return (T)this.pages[pageIndex][indexInPage];
    }

    @Override
    public T set(long index, T value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        Object[] page = this.pages[pageIndex];
        Object ret = page[indexInPage];
        page[indexInPage] = value;
        return (T)ret;
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (Object[][])Arrays.copyOf(this.pages, ArrayUtil.oversize((int)numPages, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newObjectPage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }
}

