/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.compress;

import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.Streams;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.compress.Compressor;
import io.skylite.core.compress.CompressorRegistry;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public final class CompressedXContent {
    private final byte[] bytes;
    private final int crc32;

    private static int crc32(BytesReference data) {
        CRC32 crc32 = new CRC32();
        try {
            data.writeTo(new CheckedOutputStream(Streams.NULL_OUTPUT_STREAM, crc32));
        }
        catch (IOException bogus) {
            throw new Error(bogus);
        }
        return (int)crc32.getValue();
    }

    private CompressedXContent(byte[] compressed, int crc32) {
        this.bytes = compressed;
        this.crc32 = crc32;
        this.assertConsistent();
    }

    public CompressedXContent(ToXContent xcontent, ToXContent.Params params) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        OutputStream compressedStream = CompressorRegistry.defaultCompressor().threadLocalOutputStream(bStream);
        CRC32 crc32 = new CRC32();
        CheckedOutputStream checkedStream = new CheckedOutputStream(compressedStream, crc32);
        try (XContentBuilder builder = MediaTypeRegistry.contentBuilder(MediaTypeRegistry.JSON, checkedStream);){
            if (xcontent.isFragment()) {
                builder.startObject();
            }
            xcontent.toXContent(builder, params);
            if (xcontent.isFragment()) {
                builder.endObject();
            }
        }
        this.bytes = BytesReference.toBytes(bStream.bytes());
        this.crc32 = (int)crc32.getValue();
        this.assertConsistent();
    }

    public CompressedXContent(BytesReference data) throws IOException {
        Compressor compressor = CompressorRegistry.compressor(data);
        if (compressor != null) {
            this.bytes = BytesReference.toBytes(data);
            this.crc32 = CompressedXContent.crc32(this.uncompressed());
        } else {
            this.bytes = BytesReference.toBytes(CompressorRegistry.defaultCompressor().compress(data));
            this.crc32 = CompressedXContent.crc32(data);
        }
        this.assertConsistent();
    }

    private void assertConsistent() {
        assert (CompressorRegistry.compressor(new BytesArray(this.bytes)) != null);
        assert (this.crc32 == CompressedXContent.crc32(this.uncompressed()));
    }

    public CompressedXContent(byte[] data) throws IOException {
        this(new BytesArray(data));
    }

    public CompressedXContent(String str) throws IOException {
        this(new BytesArray(str.getBytes(StandardCharsets.UTF_8)));
    }

    public byte[] compressed() {
        return this.bytes;
    }

    public BytesReference compressedReference() {
        return new BytesArray(this.bytes);
    }

    public BytesReference uncompressed() {
        try {
            return CompressorRegistry.uncompress(new BytesArray(this.bytes));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot decompress compressed string", e);
        }
    }

    public String string() {
        return this.uncompressed().utf8ToString();
    }

    public static CompressedXContent readCompressedString(StreamInput in) throws IOException {
        int crc32 = in.readInt();
        return new CompressedXContent(in.readByteArray(), crc32);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.crc32);
        out.writeByteArray(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressedXContent that = (CompressedXContent)o;
        if (Arrays.equals(this.compressed(), that.compressed())) {
            return true;
        }
        if (this.crc32 != that.crc32) {
            return false;
        }
        return this.uncompressed().equals(that.uncompressed());
    }

    public int hashCode() {
        return this.crc32;
    }

    public String toString() {
        return this.string();
    }
}

