/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.crypto;

import io.skylite.OpenSearchVersion;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;

public class CryptoRegistryException
extends SkyliteException {
    private final String name;
    private final String type;
    private final RestStatus restStatus;

    public CryptoRegistryException(String clientName, String clientType) {
        super("[Missing crypto registry for client name : " + clientName + " of type " + clientType + " ]", new Object[0]);
        this.name = clientName;
        this.type = clientType;
        this.restStatus = RestStatus.NOT_FOUND;
    }

    public CryptoRegistryException(String clientName, String clientType, Throwable cause) {
        super("[Client name : " + clientName + " Type " + clientType + " ]", cause, new Object[0]);
        this.name = clientName;
        this.type = clientType;
        this.restStatus = cause instanceof IllegalArgumentException ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR;
    }

    public CryptoRegistryException(String clientName, String clientType, String msg) {
        super("[ " + msg + " Client name : " + clientName + " type " + clientType + " ] ", new Object[0]);
        this.name = clientName;
        this.type = clientType;
        this.restStatus = RestStatus.INTERNAL_SERVER_ERROR;
    }

    @Override
    public RestStatus status() {
        return this.restStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public CryptoRegistryException(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.type = in.readString();
        this.restStatus = RestStatus.fromCode(in.readInt());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeInt(this.restStatus.getStatus());
    }

    public static class Registration
    implements SkyliteExceptionProvider<CryptoRegistryException> {
        @Override
        public Class<CryptoRegistryException> getExceptionClass() {
            return CryptoRegistryException.class;
        }

        @Override
        public CheckedFunction<StreamInput, CryptoRegistryException, IOException> getConstructor() {
            return CryptoRegistryException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return OpenSearchVersion.V_2_10_0;
        }

        @Override
        public int getLegacyId() {
            return 171;
        }
    }
}

