/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.crypto;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;

public class CryptoSettings
implements Writeable,
ToXContentObject {
    private String keyProviderName;
    private String keyProviderType;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;

    public CryptoSettings(StreamInput in) throws IOException {
        this.keyProviderName = in.readString();
        this.keyProviderType = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
    }

    public CryptoSettings(String keyProviderName) {
        this.keyProviderName = keyProviderName;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.keyProviderName == null) {
            validationException = ValidateActions.addValidationError((String)"key_provider_name is missing", validationException);
        }
        if (this.keyProviderType == null) {
            validationException = ValidateActions.addValidationError((String)"key_provider_type is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getKeyProviderName() {
        return this.keyProviderName;
    }

    public String getKeyProviderType() {
        return this.keyProviderType;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public CryptoSettings keyProviderName(String keyProviderName) {
        this.keyProviderName = keyProviderName;
        return this;
    }

    public CryptoSettings keyProviderType(String keyProviderType) {
        this.keyProviderType = keyProviderType;
        return this;
    }

    public CryptoSettings settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CryptoSettings settings(String source, MediaType mediaType) {
        this.settings = Settings.builder().loadFromSource(source, mediaType).build();
        return this;
    }

    public CryptoSettings settings(Map<String, Object> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public CryptoSettings(Map<String, Object> cryptoDefinition) {
        for (Map.Entry<String, Object> entry : cryptoDefinition.entrySet()) {
            if (entry.getKey().equals("key_provider_name")) {
                this.keyProviderName(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().equals("key_provider_type")) {
                this.keyProviderType(entry.getValue().toString());
                continue;
            }
            if (!entry.getKey().equals("settings")) continue;
            if (!(entry.getValue() instanceof Map)) {
                throw new IllegalArgumentException("Malformed settings section in crypto settings, should include an inner object");
            }
            Map sub = (Map)entry.getValue();
            this.settings(sub);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.keyProviderName);
        out.writeString(this.keyProviderType);
        Settings.writeSettingsToStream(this.settings, out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("key_provider_name", this.keyProviderName);
        builder.field("key_provider_type", this.keyProviderType);
        builder.startObject("settings");
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

