/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.discovery;

import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class DiscoveryModuleSettings {
    public static final String ZEN2_DISCOVERY_TYPE = "zen";
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "zen", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> DISCOVERY_SEED_PROVIDERS_SETTING = Setting.listSetting("discovery.seed_providers", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final String DEFAULT_ELECTION_STRATEGY = "default";
    public static final Setting<String> ELECTION_STRATEGY_SETTING = new Setting("cluster.election.strategy", "default", Function.identity(), Setting.Property.NodeScope);
    public static final String SINGLE_NODE_DISCOVERY_TYPE = "single-node";

    public static boolean isSingleNodeDiscoveryEnabled(Settings settings) {
        return SINGLE_NODE_DISCOVERY_TYPE.equals(DISCOVERY_TYPE_SETTING.get(settings));
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(DISCOVERY_TYPE_SETTING, DISCOVERY_SEED_PROVIDERS_SETTING, ELECTION_STRATEGY_SETTING);
        }
    }
}

