/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.discovery;

import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.discovery.SeedHostsProvider;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.transport.TransportService;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingsBasedSeedHostsProvider
implements SeedHostsProvider {
    private static final Logger logger = LogManager.getLogger(SettingsBasedSeedHostsProvider.class);
    public static final Setting<List<String>> DISCOVERY_SEED_HOSTS_SETTING = Setting.listSetting("discovery.seed_hosts", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private final List<String> configuredHosts;

    public SettingsBasedSeedHostsProvider(Settings settings, TransportService transportService) {
        this.configuredHosts = DISCOVERY_SEED_HOSTS_SETTING.exists(settings) ? DISCOVERY_SEED_HOSTS_SETTING.get(settings) : transportService.getDefaultSeedAddresses();
        logger.debug("using initial hosts {}", this.configuredHosts);
    }

    @Override
    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        return hostsResolver.resolveHosts(this.configuredHosts);
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(DISCOVERY_SEED_HOSTS_SETTING);
        }
    }
}

