/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.geo;

import io.skylite.SkyliteParseException;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.ShapeType;
import io.skylite.common.geometry.utils.CartesianValidator;
import io.skylite.common.geometry.utils.GeometryValidator;
import io.skylite.common.geometry.utils.WellKnownText;
import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MapXContentParser;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentSubParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;

public class CartesianPoint
implements ToXContentFragment {
    protected double x;
    protected double y;
    public static final ParseField X_FIELD = new ParseField("x", new String[0]);
    public static final ParseField Y_FIELD = new ParseField("y", new String[0]);
    public static final ParseField Z_FIELD = new ParseField("z", new String[0]);

    public CartesianPoint() {
    }

    public CartesianPoint(String value) {
        this.resetFromString(value);
    }

    public CartesianPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public CartesianPoint(CartesianPoint template) {
        this(template.getX(), template.getY());
    }

    public CartesianPoint(StreamInput in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
    }

    public CartesianPoint reset(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public CartesianPoint resetX(double x) {
        this.x = x;
        return this;
    }

    public CartesianPoint resetY(double y) {
        this.y = y;
        return this;
    }

    public CartesianPoint resetFromString(String value) {
        return this.resetFromString(value, false);
    }

    public CartesianPoint resetFromString(String value, boolean ignoreZValue) {
        if (value.toLowerCase(Locale.ROOT).contains("point")) {
            return this.resetFromWKT(value, ignoreZValue);
        }
        return this.resetFromCoordinates(value, ignoreZValue);
    }

    public CartesianPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        double y;
        double x;
        String[] vals = value.split(",");
        if (vals.length > 3) {
            throw new SkyliteParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", value, vals.length);
        }
        try {
            x = Double.parseDouble(vals[0].trim());
        }
        catch (NumberFormatException e) {
            throw new SkyliteParseException("x value must be a number", new Object[0]);
        }
        try {
            y = Double.parseDouble(vals[1].trim());
        }
        catch (NumberFormatException e) {
            throw new SkyliteParseException("y value must be a number", new Object[0]);
        }
        if (vals.length > 2) {
            GeoPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
        }
        return this.reset(x, y);
    }

    private CartesianPoint resetFromWKT(String value, boolean ignoreZValue) {
        Geometry geometry;
        try {
            geometry = new WellKnownText(false, (GeometryValidator)new CartesianValidator(ignoreZValue)).fromWKT(value);
        }
        catch (IOException | ParseException e) {
            throw new SkyliteParseException("Invalid WKT format", (Throwable)e, new Object[0]);
        }
        if (geometry.type() != ShapeType.POINT) {
            throw new SkyliteParseException("[point] supports only POINT among WKT primitives, but found: " + String.valueOf(geometry.type()), new Object[0]);
        }
        Point point = (Point)geometry;
        return this.reset(point.getX(), point.getY());
    }

    public static CartesianPoint parsePoint(Object value, CartesianPoint point, boolean ignoreZValue) throws SkyliteParseException {
        CartesianPoint cartesianPoint;
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("null_value", value), null);
        try {
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            cartesianPoint = CartesianPoint.parsePoint(parser, point, ignoreZValue);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new SkyliteParseException("error parsing point", (Throwable)ex, new Object[0]);
            }
        }
        parser.close();
        return cartesianPoint;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CartesianPoint parsePoint(XContentParser parser, CartesianPoint point, boolean ignoreZvalue) throws IOException, SkyliteParseException {
        block37: {
            x = NaN;
            y = NaN;
            numberFormatException = null;
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) break block37;
            subParser = new XContentSubParser(parser);
            ** GOTO lbl15
        }
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            if (parser.currentToken() != XContentParser.Token.VALUE_STRING) throw new SkyliteParseException("point expected", new Object[0]);
            val = parser.text();
            return point.resetFromString(val, ignoreZvalue);
        }
        subParser = new XContentSubParser(parser);
        try {
            block38: {
                break block38;
lbl15:
                // 1 sources

                try {
                    block25: while (subParser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if (subParser.currentToken() != XContentParser.Token.FIELD_NAME) {
                            throw new SkyliteParseException("token [{}] not allowed", new Object[]{subParser.currentToken()});
                        }
                        field = subParser.currentName();
                        if (field.equals(CartesianPoint.X_FIELD.getPreferredName())) {
                            subParser.nextToken();
                            switch (1.$SwitchMap$io$skylite$core$xcontent$XContentParser$Token[subParser.currentToken().ordinal()]) {
                                case 1: 
                                case 2: {
                                    try {
                                        x = subParser.doubleValue(true);
                                    }
                                    catch (NumberFormatException e) {
                                        numberFormatException = e;
                                    }
                                    continue block25;
                                }
                            }
                            throw new SkyliteParseException("[{}] must be a number", new Object[]{CartesianPoint.X_FIELD.getPreferredName()});
                        }
                        if (field.equals(CartesianPoint.Y_FIELD.getPreferredName())) {
                            subParser.nextToken();
                            switch (1.$SwitchMap$io$skylite$core$xcontent$XContentParser$Token[subParser.currentToken().ordinal()]) {
                                case 1: 
                                case 2: {
                                    try {
                                        y = subParser.doubleValue(true);
                                    }
                                    catch (NumberFormatException e) {
                                        numberFormatException = e;
                                    }
                                    continue block25;
                                }
                            }
                            throw new SkyliteParseException("[{}] must be a number", new Object[]{CartesianPoint.Y_FIELD.getPreferredName()});
                        }
                        if (!field.equals(CartesianPoint.Z_FIELD.getPreferredName())) {
                            throw new SkyliteParseException("field must be either [{}] or [{}]", new Object[]{CartesianPoint.X_FIELD.getPreferredName(), CartesianPoint.Y_FIELD.getPreferredName()});
                        }
                        subParser.nextToken();
                        switch (1.$SwitchMap$io$skylite$core$xcontent$XContentParser$Token[subParser.currentToken().ordinal()]) {
                            case 1: 
                            case 2: {
                                try {
                                    CartesianPoint.assertZValue(ignoreZvalue, subParser.doubleValue(true));
                                }
                                catch (NumberFormatException e) {
                                    numberFormatException = e;
                                }
                                continue block25;
                            }
                        }
                        throw new SkyliteParseException("[{}] must be a number", new Object[]{CartesianPoint.Z_FIELD.getPreferredName()});
                    }
                }
                finally {
                    subParser.close();
                }
                if (numberFormatException != null) {
                    throw new SkyliteParseException("[{}] and [{}] must be valid double values", numberFormatException, new Object[]{CartesianPoint.X_FIELD.getPreferredName(), CartesianPoint.Y_FIELD.getPreferredName()});
                }
                if (Double.isNaN(x)) {
                    throw new SkyliteParseException("field [{}] missing", new Object[]{CartesianPoint.X_FIELD.getPreferredName()});
                }
                if (Double.isNaN(y) == false) return point.reset(x, y);
                throw new SkyliteParseException("field [{}] missing", new Object[]{CartesianPoint.Y_FIELD.getPreferredName()});
            }
            element = 0;
            while (subParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (subParser.currentToken() != XContentParser.Token.VALUE_NUMBER) throw new SkyliteParseException("numeric value expected", new Object[0]);
                if (++element == 1) {
                    x = subParser.doubleValue();
                    continue;
                }
                if (element != 2) throw new SkyliteParseException("[{}}] field type does not accept > 2 dimensions", new Object[]{"point"});
                y = subParser.doubleValue();
            }
            return point.reset(x, y);
        }
        finally {
            subParser.close();
        }
    }

    public static CartesianPoint parsePoint(Object value, boolean ignoreZValue) throws SkyliteParseException {
        return CartesianPoint.parsePoint(value, new CartesianPoint(), ignoreZValue);
    }

    public static double assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new SkyliteParseException("Exception parsing coordinates: found Z value [{}] but [ignore_z_value] parameter is [{}]", zValue, ignoreZValue);
        }
        if (!Double.isFinite(zValue)) {
            throw new SkyliteParseException("invalid [{}] value [{}]; must be between -3.4028234663852886E38 and 3.4028234663852886E38", Z_FIELD.getPreferredName(), zValue);
        }
        return zValue;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartesianPoint that = (CartesianPoint)o;
        return Double.compare(this.x, that.x) == 0 && Double.compare(this.y, that.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return this.x + ", " + this.y;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.cartesianXY(this.x, this.y);
    }
}

