/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.geo;

import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.Polygon;
import java.io.IOException;
import org.apache.lucene.util.SloppyMath;

public final class CircleUtils {
    public static final double EARTH_MEAN_RADIUS = 6371008.7714;
    static final int MINIMUM_NUMBER_OF_SIDES = 4;
    static final int MAXIMUM_NUMBER_OF_SIDES = 1000;

    private CircleUtils() {
    }

    public static int circleToPolygonNumSides(double radiusMeters, double errorDistance) {
        int val = (int)Math.ceil(Math.PI * 2 / Math.acos(1.0 - errorDistance / radiusMeters));
        return Math.min(1000, Math.max(4, val));
    }

    public static int ellipseToPolygonNumSides(double majorAxis, double minorAxis, double errorDistance) {
        double eccentricity = Math.sqrt(1.0 - minorAxis * minorAxis / (majorAxis * majorAxis));
        double weightedRadius = (2.0 * majorAxis + minorAxis) / 3.0;
        int baseSides = (int)Math.ceil(Math.PI * 2 / Math.acos(1.0 - errorDistance / weightedRadius));
        double axisRatioFactor = 1.0 + 0.5 * (majorAxis - minorAxis) / majorAxis;
        double eccentricityFactor = 1.0 + eccentricity;
        int adjustedSides = (int)Math.ceil((double)baseSides * eccentricityFactor * axisRatioFactor);
        return Math.min(1000, Math.max(4, adjustedSides));
    }

    public static Polygon createRegularGeoShapePolygon(Circle circle, int gons) {
        if (SloppyMath.haversinMeters((double)circle.getLat(), (double)circle.getLon(), (double)90.0, (double)0.0) < circle.getRadiusMeters()) {
            throw new IllegalArgumentException("circle [" + String.valueOf(circle) + "] contains the north pole. It cannot be translated to a polygon");
        }
        if (SloppyMath.haversinMeters((double)circle.getLat(), (double)circle.getLon(), (double)-90.0, (double)0.0) < circle.getRadiusMeters()) {
            throw new IllegalArgumentException("circle [" + String.valueOf(circle) + "] contains the south pole. It cannot be translated to a polygon");
        }
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double lon;
            double lat;
            double angle = (double)i * (360.0 / (double)gons);
            double x = Math.cos(Math.toRadians(angle));
            double y = Math.sin(Math.toRadians(angle));
            double factor = 2.0;
            double step = 1.0;
            int last = 0;
            while (true) {
                lat = circle.getLat() + y * factor;
                lon = circle.getLon() + x * factor;
                double distanceMeters = SloppyMath.haversinMeters((double)circle.getLat(), (double)circle.getLon(), (double)lat, (double)lon);
                if (Math.abs(distanceMeters - circle.getRadiusMeters()) < 0.1) break;
                if (distanceMeters > circle.getRadiusMeters()) {
                    factor -= step;
                    if (last == 1) {
                        step /= 2.0;
                    }
                    last = -1;
                    continue;
                }
                if (!(distanceMeters < circle.getRadiusMeters())) continue;
                factor += step;
                if (last == -1) {
                    step /= 2.0;
                }
                last = 1;
            }
            result[0][i] = lon;
            result[1][i] = lat;
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(new LinearRing(result[0], result[1]));
    }

    public static Polygon createRegularShapePolygon(Circle circle, int gons) {
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double angle = (double)i * (360.0 / (double)gons);
            double x = circle.getRadiusMeters() * Math.cos(Math.toRadians(angle));
            double y = circle.getRadiusMeters() * Math.sin(Math.toRadians(angle));
            result[0][i] = x + circle.getX();
            result[1][i] = y + circle.getY();
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(new LinearRing(result[0], result[1]));
    }

    public static Polygon createRegularEllipsePolygon(Ellipse ellipse, int gons) {
        if (gons < 3) {
            throw new IllegalArgumentException("The number of vertices must be at least 3.");
        }
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        double orientationRad = Math.toRadians(ellipse.getOrientationDegrees());
        for (int i = 0; i < gons; ++i) {
            double angle = (double)i * (360.0 / (double)gons);
            double x = ellipse.getSemiMinorAxisMeters() * Math.cos(Math.toRadians(angle));
            double y = ellipse.getSemiMinorAxisMeters() * Math.sin(Math.toRadians(angle));
            double xRot = x * Math.cos(orientationRad) - y * Math.sin(orientationRad);
            double yRot = x * Math.sin(orientationRad) + y * Math.cos(orientationRad);
            result[0][i] = xRot + ellipse.getX();
            result[1][i] = yRot + ellipse.getY();
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(new LinearRing(result[0], result[1]));
    }

    public static Polygon ellipseToRegularGeoShapePolygon(Ellipse ellipse, int gons) throws IOException {
        if (gons < 4) {
            throw new IllegalArgumentException("The number of vertexes must be at least 4.");
        }
        double orientationRad = Math.toRadians(ellipse.getOrientationDegrees());
        double[][] result = new double[][]{new double[gons + 1], new double[gons + 1]};
        double centerLatRad = Math.toRadians(ellipse.getLat());
        for (int i = 0; i < gons; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)gons;
            double x = ellipse.getSemiMajorAxisMeters() * Math.cos(angle);
            double y = ellipse.getSemiMinorAxisMeters() * Math.sin(angle);
            double xRot = x * Math.cos(orientationRad) - y * Math.sin(orientationRad);
            double yRot = x * Math.sin(orientationRad) + y * Math.cos(orientationRad);
            double deltaLat = yRot / 6371008.7714;
            double deltaLon = xRot / (6371008.7714 * Math.cos(centerLatRad));
            double vertexLat = ellipse.getLat() + Math.toDegrees(deltaLat);
            double vertexLon = ellipse.getLon() + Math.toDegrees(deltaLon);
            if (vertexLat > 90.0 || vertexLat < -90.0) {
                throw new IOException("Ellipse crosses the poles at latitude: " + vertexLat);
            }
            result[0][i] = vertexLon = (vertexLon + 540.0) % 360.0 - 180.0;
            result[1][i] = vertexLat;
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new Polygon(new LinearRing(result[0], result[1]));
    }

    public static boolean isPointInEllipse(double x, double y, double centerX, double centerY, double semiMajorAxis, double semiMinorAxis, double orientationDegrees) {
        double rotatedY;
        double normalizedY;
        double sinTheta;
        if (semiMajorAxis <= 0.0) {
            throw new IllegalArgumentException("Semi-major axis must be greater than zero.");
        }
        if (semiMinorAxis <= 0.0) {
            throw new IllegalArgumentException("Semi-minor axis must be greater than zero.");
        }
        if (orientationDegrees < 0.0 || orientationDegrees >= 360.0) {
            throw new IllegalArgumentException("Orientation must be between 0 and 360 degrees.");
        }
        double translatedX = x - centerX;
        double translatedY = y - centerY;
        double orientationRadians = Math.toRadians(orientationDegrees);
        double cosTheta = Math.cos(orientationRadians);
        double rotatedX = translatedX * cosTheta + translatedY * (sinTheta = Math.sin(orientationRadians));
        double normalizedX = rotatedX * rotatedX / (semiMajorAxis * semiMajorAxis);
        return normalizedX + (normalizedY = (rotatedY = -translatedX * sinTheta + translatedY * cosTheta) * rotatedY / (semiMinorAxis * semiMinorAxis)) <= 1.0;
    }

    public static float[] calculateCartesianEllipseBounds(double centerX, double centerY, double semiMajorAxis, double semiMinorAxis, double orientationDegrees) {
        if (semiMajorAxis <= 0.0) {
            throw new IllegalArgumentException("Semi-major axis must be greater than zero.");
        }
        if (semiMinorAxis <= 0.0) {
            throw new IllegalArgumentException("Semi-minor axis must be greater than zero.");
        }
        if (orientationDegrees < 0.0 || orientationDegrees > 360.0) {
            throw new IllegalArgumentException("Orientation must be between 0 and 360 degrees.");
        }
        double orientationRadians = Math.toRadians(orientationDegrees);
        double cosTheta = Math.cos(orientationRadians);
        double sinTheta = Math.sin(orientationRadians);
        double cosSquaredTheta = cosTheta * cosTheta;
        double sinSquaredTheta = sinTheta * sinTheta;
        double sin2Theta = Math.sin(2.0 * orientationRadians);
        double width = Math.sqrt(semiMajorAxis * semiMajorAxis * cosSquaredTheta + semiMinorAxis * semiMinorAxis * sinSquaredTheta) + Math.sqrt(semiMajorAxis * semiMajorAxis * sinSquaredTheta + semiMinorAxis * semiMinorAxis * cosSquaredTheta);
        double height = Math.abs(semiMajorAxis * semiMinorAxis * sin2Theta) / Math.sqrt(semiMajorAxis * semiMajorAxis + semiMinorAxis * semiMinorAxis);
        double minX = centerX - width / 2.0;
        double maxX = centerX + width / 2.0;
        double minY = centerY - height / 2.0;
        double maxY = centerY + height / 2.0;
        if (minX < -3.4028234663852886E38) {
            minX = -3.4028234663852886E38;
        }
        if (maxX > 3.4028234663852886E38) {
            maxX = 3.4028234663852886E38;
        }
        if (minY < -3.4028234663852886E38) {
            minY = -3.4028234663852886E38;
        }
        if (maxY > 3.4028234663852886E38) {
            maxY = 3.4028234663852886E38;
        }
        return new float[]{(float)minX, (float)minY, (float)maxX, (float)maxY};
    }

    public static boolean isPointInsideGeospatialEllipse(double pointLat, double pointLon, double centerLat, double centerLon, double semiMajorAxis, double semiMinorAxis, double orientationDegrees) {
        double projectedY;
        double normalizedY;
        if (semiMajorAxis <= 0.0 || semiMinorAxis <= 0.0) {
            throw new IllegalArgumentException("Semi-major and semi-minor axes must be positive.");
        }
        if (orientationDegrees < 0.0 || orientationDegrees >= 360.0) {
            throw new IllegalArgumentException("Orientation must be between 0 and 360 degrees.");
        }
        double orientationRad = Math.toRadians(orientationDegrees);
        double cosOrientation = Math.cos(orientationRad);
        double sinOrientation = Math.sin(orientationRad);
        double dLat = Math.toRadians(pointLat - centerLat);
        double dLon = Math.toRadians(pointLon - centerLon);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(centerLat)) * Math.cos(Math.toRadians(pointLat)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distanceToCenter = 6371008.7714 * c;
        double projectedX = distanceToCenter * cosOrientation;
        double normalizedX = projectedX / semiMajorAxis;
        return normalizedX * normalizedX + (normalizedY = (projectedY = distanceToCenter * sinOrientation) / semiMinorAxis) * normalizedY <= 1.0;
    }
}

