/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.geo;

import io.skylite.SkyliteParseException;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.ShapeType;
import io.skylite.common.geometry.utils.GeographyValidator;
import io.skylite.common.geometry.utils.Geohash;
import io.skylite.common.geometry.utils.GeometryValidator;
import io.skylite.common.geometry.utils.WellKnownText;
import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.io.stream.spi.StreamableProvider;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public class GeoPoint
implements ToXContentFragment {
    public static final String CONTENT_TYPE = "geo_point";
    protected double lat;
    protected double lon;

    public GeoPoint() {
    }

    public GeoPoint(String value) {
        this.resetFromString(value);
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public GeoPoint(GeoPoint template) {
        this(template.getLat(), template.getLon());
    }

    public GeoPoint(StreamInput in) throws IOException {
        this.lat = in.readDouble();
        this.lon = in.readDouble();
    }

    public static double normalizeLon(double lon) {
        if (lon > 180.0 || lon <= -180.0) {
            lon = GeoPoint.centeredModulus(lon, 360.0);
        }
        return lon + 0.0;
    }

    public static double normalizeLat(double lat) {
        if (lat > 90.0 || lat < -90.0) {
            if ((lat = GeoPoint.centeredModulus(lat, 360.0)) < -90.0) {
                lat = -180.0 - lat;
            } else if (lat > 90.0) {
                lat = 180.0 - lat;
            }
        }
        return lat + 0.0;
    }

    public static void normalizePoint(GeoPoint point) {
        GeoPoint.normalizePoint(point, true, true);
    }

    public static void normalizePoint(GeoPoint point, boolean normLat, boolean normLon) {
        double[] pt = new double[]{point.lon(), point.lat()};
        GeoPoint.normalizePoint(pt, normLon, normLat);
        point.reset(pt[1], pt[0]);
    }

    public static void normalizePoint(double[] lonLat) {
        GeoPoint.normalizePoint(lonLat, true, true);
    }

    public static void normalizePoint(double[] lonLat, boolean normLon, boolean normLat) {
        assert (lonLat != null && lonLat.length == 2);
        normLat = normLat && (lonLat[1] > 90.0 || lonLat[1] < -90.0);
        boolean bl = normLon = normLon && (lonLat[0] > 180.0 || lonLat[0] < -180.0 || normLat);
        if (normLat) {
            lonLat[1] = GeoPoint.centeredModulus(lonLat[1], 360.0);
            boolean shift = true;
            if (lonLat[1] < -90.0) {
                lonLat[1] = -180.0 - lonLat[1];
            } else if (lonLat[1] > 90.0) {
                lonLat[1] = 180.0 - lonLat[1];
            } else {
                shift = false;
            }
            if (shift) {
                lonLat[0] = normLon ? lonLat[0] + 180.0 : lonLat[0] + (GeoPoint.normalizeLon(lonLat[0]) > 0.0 ? -180.0 : 180.0);
            }
        }
        if (normLon) {
            lonLat[0] = GeoPoint.centeredModulus(lonLat[0], 360.0);
        }
    }

    public static double centeredModulus(double dividend, double divisor) {
        double rtn = dividend % divisor;
        if (rtn <= 0.0) {
            rtn += divisor;
        }
        if (rtn > divisor / 2.0) {
            rtn -= divisor;
        }
        return rtn;
    }

    public GeoPoint reset(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoPoint resetLat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoPoint resetLon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoPoint resetFromString(String value) {
        return this.resetFromString(value, false, Geohash.EffectivePoint.BOTTOM_LEFT);
    }

    public GeoPoint resetFromString(String value, boolean ignoreZValue, Geohash.EffectivePoint effectivePoint) {
        if (value.toLowerCase(Locale.ROOT).contains("point")) {
            return this.resetFromWKT(value, ignoreZValue);
        }
        if (value.contains(",")) {
            return this.resetFromCoordinates(value, ignoreZValue);
        }
        return this.resetFromGeoHash(value, effectivePoint);
    }

    public GeoPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        double lon;
        double lat;
        String[] vals = value.split(",");
        if (vals.length > 3) {
            throw new SkyliteParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", value, vals.length);
        }
        try {
            lat = Double.parseDouble(vals[0].trim());
        }
        catch (NumberFormatException ex) {
            throw new SkyliteParseException("latitude must be a number", new Object[0]);
        }
        try {
            lon = Double.parseDouble(vals[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new SkyliteParseException("longitude must be a number", new Object[0]);
        }
        if (vals.length > 2) {
            GeoPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
        }
        return this.reset(lat, lon);
    }

    private GeoPoint resetFromWKT(String value, boolean ignoreZValue) {
        Geometry geometry;
        try {
            geometry = new WellKnownText(false, (GeometryValidator)new GeographyValidator(ignoreZValue)).fromWKT(value);
        }
        catch (Exception e) {
            throw new SkyliteParseException("Invalid WKT format", (Throwable)e, new Object[0]);
        }
        if (geometry.type() != ShapeType.POINT) {
            throw new SkyliteParseException("[geo_point] supports only POINT among WKT primitives, but found " + String.valueOf(geometry.type()), new Object[0]);
        }
        Point point = (Point)geometry;
        return this.reset(point.getY(), point.getX());
    }

    public GeoPoint resetFromGeoHash(String geohash, Geohash.EffectivePoint effectivePoint) {
        if (effectivePoint == Geohash.EffectivePoint.BOTTOM_LEFT) {
            return this.resetFromGeoHash(geohash);
        }
        Rectangle rectangle = Geohash.toBoundingBox((String)geohash);
        switch (effectivePoint) {
            case TOP_LEFT: {
                return this.reset(rectangle.getMaxY(), rectangle.getMinX());
            }
            case TOP_RIGHT: {
                return this.reset(rectangle.getMaxY(), rectangle.getMaxX());
            }
            case BOTTOM_RIGHT: {
                return this.reset(rectangle.getMinY(), rectangle.getMaxX());
            }
        }
        throw new IllegalArgumentException("Unsupported effective point " + String.valueOf(effectivePoint));
    }

    public GeoPoint resetFromIndexHash(long hash) {
        this.lon = Geohash.decodeLongitude((long)hash);
        this.lat = Geohash.decodeLatitude((long)hash);
        return this;
    }

    public GeoPoint resetFromIndexableField(IndexableField field) {
        if (field instanceof LatLonPoint) {
            BytesRef br = field.binaryValue();
            byte[] bytes = Arrays.copyOfRange(br.bytes, br.offset, br.length);
            return this.reset(GeoEncodingUtils.decodeLatitude((byte[])bytes, (int)0), GeoEncodingUtils.decodeLongitude((byte[])bytes, (int)4));
        }
        if (field instanceof LatLonDocValuesField) {
            long encoded = (Long)field.numericValue();
            return this.reset(GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))), GeoEncodingUtils.decodeLongitude((int)((int)encoded)));
        }
        return this.resetFromIndexHash(Long.parseLong(field.stringValue()));
    }

    public GeoPoint resetFromGeoHash(String geohash) {
        long hash;
        try {
            hash = Geohash.mortonEncode((String)geohash);
        }
        catch (IllegalArgumentException ex) {
            throw new SkyliteParseException(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        return this.reset(Geohash.decodeLatitude((long)hash), Geohash.decodeLongitude((long)hash));
    }

    public GeoPoint resetFromGeoHash(long geohashLong) {
        int level = (int)(12L - (geohashLong & 0xFL));
        return this.resetFromIndexHash(BitUtil.flipFlop((long)(geohashLong >>> 4 << level * 5 + 2)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.lat);
        out.writeDouble(this.lon);
    }

    public double lat() {
        return this.lat;
    }

    public double getLat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double getLon() {
        return this.lon;
    }

    public String geohash() {
        return Geohash.stringEncode((double)this.lon, (double)this.lat);
    }

    public String getGeohash() {
        return Geohash.stringEncode((double)this.lon, (double)this.lat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        if (Double.compare(geoPoint.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = Long.hashCode(temp);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + Long.hashCode(temp);
        return result;
    }

    public String toString() {
        return this.lat + ", " + this.lon;
    }

    public static GeoPoint fromGeohash(String geohash) {
        return new GeoPoint().resetFromGeoHash(geohash);
    }

    public static GeoPoint fromGeohash(long geohashLong) {
        return new GeoPoint().resetFromGeoHash(geohashLong);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.latlon(this.lat, this.lon);
    }

    public static double assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new SkyliteParseException("Exception parsing coordinates: found Z value [{}] but [{}] parameter is [{}]", zValue, ParseField.CommonFields.IGNORE_Z_VALUE, ignoreZValue);
        }
        return zValue;
    }

    public static final class StreamableProviderImpl
    implements StreamableProvider {
        @Override
        public byte getLegacyUniqueByte() {
            return 22;
        }

        @Override
        public Class<?> getTypeClass() {
            return GeoPoint.class;
        }

        public Writeable.Writer<?> getWriter() {
            return (o, v) -> {
                o.writeByte((byte)22);
                ((GeoPoint)v).writeTo(o);
            };
        }

        public Writeable.Reader<?> getReader() {
            return GeoPoint::new;
        }
    }
}

