/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.geo;

import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.core.geo.GeoLineDecomposer;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeoPolygonDecomposer;
import io.skylite.core.geo.GeoShapeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.index.IndexableField;

public class GeoShapeIndexer {
    private final boolean orientation;
    private final String name;

    public GeoShapeIndexer(boolean orientation, String name) {
        this.orientation = orientation;
        this.name = name;
    }

    public Geometry prepareForIndexing(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return (Geometry)geometry.visit((GeometryVisitor)new GeometryVisitor<Geometry, RuntimeException>(){

            public Geometry visit(Circle circle) {
                throw new UnsupportedOperationException("circle geometry is not supported");
            }

            public Geometry visit(Ellipse ellipse) {
                throw new UnsupportedOperationException("ellipse geometry is not supported");
            }

            public Geometry visit(GeometryCollection<?> collection) {
                if (collection.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                ArrayList<Geometry> shapes = new ArrayList<Geometry>(collection.size());
                for (Geometry shape : collection) {
                    shapes.add((Geometry)shape.visit((GeometryVisitor)this));
                }
                if (shapes.size() == 1) {
                    return (Geometry)shapes.get(0);
                }
                return new GeometryCollection(shapes);
            }

            public Geometry visit(Line line) {
                ArrayList<Line> lines = new ArrayList<Line>();
                GeoLineDecomposer.decomposeLine(line, lines);
                if (lines.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine(lines);
            }

            public Geometry visit(LinearRing ring) {
                throw new UnsupportedOperationException("cannot index linear ring [" + String.valueOf(ring) + "] directly");
            }

            public Geometry visit(MultiLine multiLine) {
                ArrayList<Line> lines = new ArrayList<Line>();
                GeoLineDecomposer.decomposeMultiLine(multiLine, lines);
                if (lines.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine(lines);
            }

            public Geometry visit(MultiPoint multiPoint) {
                if (multiPoint.isEmpty()) {
                    return MultiPoint.EMPTY;
                }
                if (multiPoint.size() == 1) {
                    return (Geometry)((Point)multiPoint.get(0)).visit((GeometryVisitor)this);
                }
                ArrayList<Point> points = new ArrayList<Point>();
                for (Point point : multiPoint) {
                    points.add((Point)point.visit((GeometryVisitor)this));
                }
                return new MultiPoint(points);
            }

            public Geometry visit(MultiPolygon multiPolygon) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, GeoShapeIndexer.this.orientation, polygons);
                if (polygons.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon(polygons);
            }

            public Geometry visit(Point point) {
                double[] latlon = new double[]{point.getX(), point.getY()};
                GeoPoint.normalizePoint(latlon);
                return new Point(latlon[0], latlon[1]);
            }

            public Geometry visit(Polygon polygon) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposePolygon(polygon, GeoShapeIndexer.this.orientation, polygons);
                if (polygons.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon(polygons);
            }

            public Geometry visit(Rectangle rectangle) {
                return rectangle;
            }
        });
    }

    public List<IndexableField> indexShape(Geometry shape) {
        LuceneGeometryIndexer visitor = new LuceneGeometryIndexer(this.name);
        if ((shape = this.prepareForIndexing(shape)) == null) {
            return Collections.emptyList();
        }
        shape.visit((GeometryVisitor)visitor);
        return visitor.fields();
    }

    private static class LuceneGeometryIndexer
    implements GeometryVisitor<Void, RuntimeException> {
        private List<IndexableField> fields = new ArrayList<IndexableField>();
        private final String name;

        private LuceneGeometryIndexer(String name) {
            this.name = name;
        }

        List<IndexableField> fields() {
            return this.fields;
        }

        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while indexing shape");
        }

        public Void visit(Ellipse ellipse) {
            throw new IllegalArgumentException("invalid shape type found [Ellipse] while indexing shape");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (org.apache.lucene.geo.Line)GeoShapeUtils.toLuceneLine(line)));
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (double)point.getY(), (double)point.getX()));
            return null;
        }

        public Void visit(Polygon polygon) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (org.apache.lucene.geo.Polygon)GeoShapeUtils.toLucenePolygon(polygon)));
            return null;
        }

        public Void visit(Rectangle r) {
            if (r.getMinLon() > r.getMaxLon()) {
                Rectangle left = new Rectangle(r.getMinLon(), 180.0, r.getMaxLat(), r.getMinLat());
                this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (org.apache.lucene.geo.Polygon)GeoShapeUtils.toLucenePolygon(left)));
                Rectangle right = new Rectangle(-180.0, r.getMaxLon(), r.getMaxLat(), r.getMinLat());
                this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (org.apache.lucene.geo.Polygon)GeoShapeUtils.toLucenePolygon(right)));
            } else {
                this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (org.apache.lucene.geo.Polygon)GeoShapeUtils.toLucenePolygon(r)));
            }
            return null;
        }

        private void addFields(IndexableField[] fields) {
            this.fields.addAll(Arrays.asList(fields));
        }
    }
}

