/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.geo;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.document.ShapeField;

public enum ShapeRelation implements Writeable
{
    INTERSECTS("intersects"),
    DISJOINT("disjoint"),
    WITHIN("within"),
    CONTAINS("contains");

    private final String relationName;

    private ShapeRelation(String relationName) {
        this.relationName = relationName;
    }

    public static ShapeRelation readFromStream(StreamInput in) throws IOException {
        return in.readEnum(ShapeRelation.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static ShapeRelation getRelationByName(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        for (ShapeRelation relation : ShapeRelation.values()) {
            if (!relation.relationName.equals(name)) continue;
            return relation;
        }
        return null;
    }

    public ShapeField.QueryRelation getLuceneRelation() {
        switch (this.ordinal()) {
            case 0: {
                return ShapeField.QueryRelation.INTERSECTS;
            }
            case 1: {
                return ShapeField.QueryRelation.DISJOINT;
            }
            case 2: {
                return ShapeField.QueryRelation.WITHIN;
            }
            case 3: {
                return ShapeField.QueryRelation.CONTAINS;
            }
        }
        throw new IllegalArgumentException("ShapeRelation [" + String.valueOf(this) + "] not supported");
    }

    public String getRelationName() {
        return this.relationName;
    }
}

