/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.identity;

import io.skylite.SkyliteException;
import io.skylite.core.identity.Subject;
import io.skylite.core.identity.noop.NoopIdentityPlugin;
import io.skylite.core.identity.tokens.TokenManager;
import io.skylite.core.plugins.IdentityPlugin;
import io.skylite.core.settings.Settings;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IdentityService {
    private static final Logger log = LogManager.getLogger(IdentityService.class);
    private final Settings settings;
    private final IdentityPlugin identityPlugin;

    public IdentityService(Settings settings, List<IdentityPlugin> identityPlugins) {
        this.settings = settings;
        if (identityPlugins.size() == 0) {
            log.debug("Identity plugins size is 0");
            this.identityPlugin = new NoopIdentityPlugin();
        } else if (identityPlugins.size() == 1) {
            log.debug("Identity plugins size is 1");
            this.identityPlugin = identityPlugins.get(0);
        } else {
            throw new SkyliteException("Multiple identity plugins are not supported, found: " + identityPlugins.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining(",")), new Object[0]);
        }
    }

    public Subject getSubject() {
        return this.identityPlugin.getSubject();
    }

    public TokenManager getTokenManager() {
        return this.identityPlugin.getTokenManager();
    }
}

