/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index;

import io.skylite.common.Nullable;
import io.skylite.common.TriFunction;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.client.Client;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.AbstractIndexComponent;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.IndexSortConfig;
import io.skylite.core.index.analysis.IndexAnalyzers;
import io.skylite.core.index.cache.IndexCache;
import io.skylite.core.index.cache.bitset.BitsetFilterCache;
import io.skylite.core.index.cache.query.QueryCache;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexFieldDataService;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.SearchIndexNameMatcher;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardNotFoundException;
import io.skylite.core.index.similarity.SimilarityService;
import io.skylite.core.index.warmer.IndexWarmer;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.indices.cluster.AllocatedIndexInterface;
import io.skylite.core.indices.fielddata.cache.IndicesFieldDataCache;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.MapperRegistry;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.script.ScriptService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;

public abstract class BaseIndexService
extends AbstractIndexComponent
implements AllocatedIndexInterface<BaseIndexShard> {
    protected final IndexFieldDataService indexFieldData;
    protected final BitsetFilterCache bitsetFilterCache;
    protected final MapperService mapperService;
    protected final BooleanSupplier allowExpensiveQueries;
    protected final NamedWriteableRegistry namedWriteableRegistry;
    protected final NamedXContentRegistry xContentRegistry;
    protected final SimilarityService similarityService;
    protected final CircuitBreakerService circuitBreakerService;
    protected final ThreadPool threadPool;
    protected final IndexNameExpressionResolver expressionResolver;
    protected final AggregationRegistry aggregationRegistry;
    protected final Supplier<Sort> indexSortSupplier;
    protected final IndexWarmer warmer;
    protected final Client client;
    protected final IndexCache indexCache;
    protected final ScriptService scriptService;
    protected volatile Map<Integer, BaseIndexShard> shards = Collections.emptyMap();
    protected final IndexSettings indexSettings;
    protected final BigArrays bigArrays;
    protected final ClusterService clusterService;

    protected BaseIndexService(IndexSettings indexSettings, IndexCreationContext indexCreationContext, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, IndexAnalyzers indexAnalyzers, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ScriptService scriptService, ClusterService clusterService, Client client, QueryCache queryCache, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache, BooleanSupplier idFieldDataEnabled, BooleanSupplier allowExpensiveQueries, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, AggregationRegistry aggregationRegistry) {
        super(indexSettings);
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.indexSettings = indexSettings;
        this.xContentRegistry = xContentRegistry;
        this.similarityService = similarityService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.circuitBreakerService = circuitBreakerService;
        this.expressionResolver = expressionResolver;
        this.aggregationRegistry = aggregationRegistry;
        if (BaseIndexService.needsMapperService(indexSettings, indexCreationContext)) {
            assert (indexAnalyzers != null);
            this.mapperService = new MapperService(indexSettings, indexAnalyzers, xContentRegistry, similarityService, mapperRegistry, () -> this.newQueryShardContext(0, null, System::currentTimeMillis, null), idFieldDataEnabled, scriptService);
            this.indexFieldData = new IndexFieldDataService(indexSettings, indicesFieldDataCache, circuitBreakerService, this.mapperService);
            if (indexSettings.getIndexSortConfig().hasIndexSort()) {
                boolean shouldWidenIndexSortType = this.indexSettings.shouldWidenIndexSortType();
                this.indexSortSupplier = () -> indexSettings.getIndexSortConfig().buildIndexSort(shouldWidenIndexSortType, this.mapperService::fieldType, (TriFunction<IndexSortConfig.FieldSortSpec, Function<String, BaseMappedFieldType>, Boolean, SortField>)((TriFunction)this.indexFieldData::getSortField));
            } else {
                this.indexSortSupplier = () -> null;
            }
            this.indexFieldData.setListener(new FieldDataCacheListener(this, this));
            this.bitsetFilterCache = new BitsetFilterCache(indexSettings, new BitsetCacheListener(this));
            this.warmer = new IndexWarmer(threadPool, this.indexFieldData, this.bitsetFilterCache.createListener(threadPool));
            this.indexCache = new IndexCache(indexSettings, queryCache, this.bitsetFilterCache);
        } else {
            assert (indexAnalyzers == null);
            this.mapperService = null;
            this.indexFieldData = null;
            this.indexSortSupplier = () -> null;
            this.bitsetFilterCache = null;
            this.warmer = null;
            this.indexCache = null;
        }
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.client = client;
    }

    public static boolean needsMapperService(IndexSettings indexSettings, IndexCreationContext indexCreationContext) {
        return false == (indexSettings.getIndexMetadata().getState() == IndexMetadata.State.CLOSE && indexCreationContext == IndexCreationContext.CREATE_INDEX);
    }

    public QueryShardContext newQueryShardContext(int shardId, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias) {
        return this.newQueryShardContext(shardId, searcher, nowInMillis, clusterAlias, Collections.emptyMap());
    }

    public QueryShardContext newQueryShardContext(int shardId, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Map<String, Object> runtimeMappings) {
        return this.newQueryShardContext(shardId, searcher, nowInMillis, clusterAlias, runtimeMappings, false);
    }

    public QueryShardContext newQueryShardContext(int shardId, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Map<String, Object> runtimeMappings, boolean validate) {
        SearchIndexNameMatcher indexNameMatcher = new SearchIndexNameMatcher(this.index().getName(), clusterAlias, this.clusterService, this.expressionResolver);
        return new QueryShardContext(shardId, this.indexSettings, this.bigArrays, this.indexCache.bitsetFilterCache(), this.indexFieldData::getForField, this.mapperService, this.mapperService.mappingLookup(), this.similarityService, this.scriptService, this.xContentRegistry, this.namedWriteableRegistry, (SkyliteClient)this.client, searcher, nowInMillis, clusterAlias, indexNameMatcher, this.allowExpensiveQueries, this.aggregationRegistry, runtimeMappings, validate);
    }

    @Override
    @Nullable
    public BaseIndexShard getShardOrNull(int shardId) {
        return this.shards.get(shardId);
    }

    public BaseIndexShard getShard(int shardId) {
        BaseIndexShard indexShard = this.getShardOrNull(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(this.index(), shardId));
        }
        return indexShard;
    }

    @Override
    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public static enum IndexCreationContext {
        CREATE_INDEX,
        METADATA_VERIFICATION;

    }

    private final class FieldDataCacheListener
    implements IndexFieldDataCache.Listener {
        final BaseIndexService indexService;

        FieldDataCacheListener(BaseIndexService baseIndexService, BaseIndexService indexService) {
            this.indexService = indexService;
        }

        @Override
        public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
            BaseIndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                shard.fieldData().onCache(shardId, fieldName, ramUsage);
            }
        }

        @Override
        public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
            BaseIndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                shard.fieldData().onRemoval(shardId, fieldName, wasEvicted, sizeInBytes);
            }
        }
    }

    private static final class BitsetCacheListener
    implements BitsetFilterCache.Listener {
        final BaseIndexService indexService;

        private BitsetCacheListener(BaseIndexService indexService) {
            this.indexService = indexService;
        }

        @Override
        public void onCache(ShardId shardId, Accountable accountable) {
            BaseIndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                long ramBytesUsed = accountable != null ? accountable.ramBytesUsed() : 0L;
                shard.shardBitsetFilterCache().onCached(ramBytesUsed);
            }
        }

        @Override
        public void onRemoval(ShardId shardId, Accountable accountable) {
            BaseIndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                long ramBytesUsed = accountable != null ? accountable.ramBytesUsed() : 0L;
                shard.shardBitsetFilterCache().onRemoval(ramBytesUsed);
            }
        }
    }
}

