/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index;

import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.util.Constants;

public final class IndexModuleSettings {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IndexModuleSettings.class);
    public static final Setting<String> INDEX_RECOVERY_TYPE_SETTING = new Setting("index.recovery.type", "", Function.identity(), Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_ENABLED_SETTING = Setting.boolSetting("index.queries.cache.enabled", true, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_EVERYTHING_SETTING = Setting.boolSetting("index.queries.cache.everything", false, Setting.Property.IndexScope);

    private IndexModuleSettings() {
    }

    public static Type defaultStoreType(boolean allowMmap) {
        if (allowMmap && Constants.JRE_IS_64BIT) {
            return Type.HYBRIDFS;
        }
        return Type.NIOFS;
    }

    public static enum Type {
        HYBRIDFS("hybridfs"),
        NIOFS("niofs"),
        MMAPFS("mmapfs"),
        SIMPLEFS("simplefs"),
        FS("fs"),
        REMOTE_SNAPSHOT("remote_snapshot");

        private final String settingsKey;
        private final boolean deprecated;
        private static final Map<String, Type> TYPES;

        private Type(String settingsKey) {
            this(settingsKey, false);
        }

        private Type(String settingsKey, boolean deprecated) {
            this.settingsKey = settingsKey;
            this.deprecated = deprecated;
        }

        public String getSettingsKey() {
            return this.settingsKey;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public static boolean containsSettingsKey(String key) {
            return TYPES.containsKey(key);
        }

        public static Type fromSettingsKey(String key) {
            Type type = TYPES.get(key);
            if (type == null) {
                throw new IllegalArgumentException("no matching store type for [" + key + "]");
            }
            if (type.isDeprecated()) {
                DEPRECATION_LOGGER.deprecate(type.getSettingsKey(), " is deprecated and will be removed in 2.0", new Object[0]);
            }
            return type;
        }

        public boolean match(String setting) {
            return this.getSettingsKey().equals(setting);
        }

        public boolean match(Settings settings) {
            return this.match(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.get(settings));
        }

        static {
            HashMap<String, Type> types = new HashMap<String, Type>(Type.values().length);
            for (Type type : Type.values()) {
                types.put(type.settingsKey, type);
            }
            TYPES = Collections.unmodifiableMap(types);
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(IndexStoreSettings.NODE_STORE_ALLOW_MMAP, IndexStoreSettings.INDEX_STORE_TYPE_SETTING, IndexStoreSettings.INDEX_STORE_PRE_LOAD_SETTING, IndexStoreSettings.INDEX_STORE_HYBRID_MMAP_EXTENSIONS, IndexStoreSettings.INDEX_STORE_HYBRID_NIO_EXTENSIONS, INDEX_RECOVERY_TYPE_SETTING, INDEX_QUERY_CACHE_ENABLED_SETTING);
        }
    }
}

