/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index;

import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import java.io.IOException;

public final class IndexNotFoundException
extends ResourceNotFoundException {
    public IndexNotFoundException(String message, String index) {
        super("no such index [" + index + "] and " + message, new Object[0]);
        this.setIndex(index);
    }

    public IndexNotFoundException(String index) {
        this(index, (Throwable)null);
    }

    public IndexNotFoundException(String index, Throwable cause) {
        super("no such index [" + index + "]", cause, new Object[0]);
        this.setIndex(index);
    }

    public IndexNotFoundException(Index index) {
        this(index, null);
    }

    public IndexNotFoundException(Index index, Throwable cause) {
        super("no such index [" + index.getName() + "]", cause, new Object[0]);
        this.setIndex(index);
    }

    public IndexNotFoundException(StreamInput in) throws IOException {
        super(in);
    }

    public static class Registration
    implements SkyliteExceptionProvider<IndexNotFoundException> {
        @Override
        public Class<IndexNotFoundException> getExceptionClass() {
            return IndexNotFoundException.class;
        }

        @Override
        public CheckedFunction<StreamInput, IndexNotFoundException, IOException> getConstructor() {
            return IndexNotFoundException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 16;
        }
    }
}

