/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index;

import io.skylite.common.TriFunction;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;

public final class IndexSortConfig {
    public static final Setting<List<String>> INDEX_SORT_FIELD_SETTING = Setting.listSetting("index.sort.field", Collections.emptyList(), Function.identity(), Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<List<SortOrder>> INDEX_SORT_ORDER_SETTING = Setting.listSetting("index.sort.order", Collections.emptyList(), IndexSortConfig::parseOrderMode, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<List<MultiValueMode>> INDEX_SORT_MODE_SETTING = Setting.listSetting("index.sort.mode", Collections.emptyList(), IndexSortConfig::parseMultiValueMode, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<List<String>> INDEX_SORT_MISSING_SETTING = Setting.listSetting("index.sort.missing", Collections.emptyList(), IndexSortConfig::validateMissingValue, Setting.Property.IndexScope, Setting.Property.Final);
    final FieldSortSpec[] sortSpecs;
    private static final EnumSet<SortField.Type> ALLOWED_INDEX_SORT_TYPES = EnumSet.of(SortField.Type.STRING, SortField.Type.LONG, SortField.Type.INT, SortField.Type.DOUBLE, SortField.Type.FLOAT);

    private static String validateMissingValue(String missing) {
        if (!"_last".equals(missing) && !"_first".equals(missing)) {
            throw new IllegalArgumentException("Illegal missing value:[" + missing + "], must be one of [_last, _first]");
        }
        return missing;
    }

    private static SortOrder parseOrderMode(String value) {
        try {
            return SortOrder.fromString(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal sort order:" + value);
        }
    }

    private static MultiValueMode parseMultiValueMode(String value) {
        MultiValueMode mode = MultiValueMode.fromString(value);
        if (mode != MultiValueMode.MAX && mode != MultiValueMode.MIN) {
            throw new IllegalArgumentException("Illegal index sort mode:[" + String.valueOf(mode) + "], must be one of [" + String.valueOf(MultiValueMode.MAX) + ", " + String.valueOf(MultiValueMode.MIN) + "]");
        }
        return mode;
    }

    public IndexSortConfig(IndexSettings indexSettings) {
        int i;
        Settings settings = indexSettings.getSettings();
        List<String> fields = INDEX_SORT_FIELD_SETTING.get(settings);
        this.sortSpecs = (FieldSortSpec[])fields.stream().map(name -> new FieldSortSpec((String)name)).toArray(FieldSortSpec[]::new);
        if (INDEX_SORT_ORDER_SETTING.exists(settings)) {
            List<SortOrder> orders = INDEX_SORT_ORDER_SETTING.get(settings);
            if (orders.size() != this.sortSpecs.length) {
                throw new IllegalArgumentException("index.sort.field:" + String.valueOf(fields) + " index.sort.order:" + orders.toString() + ", size mismatch");
            }
            for (i = 0; i < this.sortSpecs.length; ++i) {
                this.sortSpecs[i].order = orders.get(i);
            }
        }
        if (INDEX_SORT_MODE_SETTING.exists(settings)) {
            List<MultiValueMode> modes = INDEX_SORT_MODE_SETTING.get(settings);
            if (modes.size() != this.sortSpecs.length) {
                throw new IllegalArgumentException("index.sort.field:" + String.valueOf(fields) + " index.sort.mode:" + String.valueOf(modes) + ", size mismatch");
            }
            for (i = 0; i < this.sortSpecs.length; ++i) {
                this.sortSpecs[i].mode = modes.get(i);
            }
        }
        if (INDEX_SORT_MISSING_SETTING.exists(settings)) {
            List<String> missingValues = INDEX_SORT_MISSING_SETTING.get(settings);
            if (missingValues.size() != this.sortSpecs.length) {
                throw new IllegalArgumentException("index.sort.field:" + String.valueOf(fields) + " index.sort.missing:" + String.valueOf(missingValues) + ", size mismatch");
            }
            for (i = 0; i < this.sortSpecs.length; ++i) {
                this.sortSpecs[i].missingValue = missingValues.get(i);
            }
        }
    }

    public boolean hasIndexSort() {
        return this.sortSpecs.length > 0;
    }

    public boolean hasPrimarySortOnField(String field) {
        return this.sortSpecs.length > 0 && this.sortSpecs[0].field.equals(field);
    }

    public Sort buildIndexSort(boolean shouldWidenIndexSortType, Function<String, BaseMappedFieldType> fieldTypeLookup, TriFunction<FieldSortSpec, Function<String, BaseMappedFieldType>, Boolean, SortField> sortFieldSupplier) {
        if (!this.hasIndexSort()) {
            return null;
        }
        SortField[] sortFields = new SortField[this.sortSpecs.length];
        for (int i = 0; i < this.sortSpecs.length; ++i) {
            FieldSortSpec sortSpec = this.sortSpecs[i];
            sortFields[i] = (SortField)sortFieldSupplier.apply((Object)sortSpec, fieldTypeLookup, (Object)shouldWidenIndexSortType);
            this.validateIndexSortField(sortFields[i]);
        }
        return new Sort(sortFields);
    }

    private void validateIndexSortField(SortField sortField) {
        SortField.Type type = IndexSortConfig.getSortFieldType(sortField);
        if (!ALLOWED_INDEX_SORT_TYPES.contains(type)) {
            throw new IllegalArgumentException("invalid index sort field:[" + sortField.getField() + "]");
        }
    }

    public static SortField.Type getSortFieldType(SortField sortField) {
        if (sortField instanceof SortedSetSortField) {
            return SortField.Type.STRING;
        }
        if (sortField instanceof SortedNumericSortField) {
            return ((SortedNumericSortField)sortField).getNumericType();
        }
        return sortField.getType();
    }

    public static class FieldSortSpec {
        final String field;
        SortOrder order;
        MultiValueMode mode;
        String missingValue;

        FieldSortSpec(String field) {
            this.field = field;
        }

        public String getField() {
            return this.field;
        }

        public SortOrder getOrder() {
            return this.order;
        }

        public MultiValueMode getMode() {
            return this.mode;
        }

        public String getMissingValue() {
            return this.missingValue;
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(INDEX_SORT_FIELD_SETTING, INDEX_SORT_ORDER_SETTING, INDEX_SORT_MISSING_SETTING, INDEX_SORT_MODE_SETTING);
        }
    }
}

