/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.SegmentReplicationShardStats;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Set;

public class SegmentReplicationPerGroupStats
implements Writeable,
ToXContentFragment {
    private final ShardId shardId;
    private final Set<SegmentReplicationShardStats> replicaStats;
    private final long rejectedRequestCount;

    public SegmentReplicationPerGroupStats(ShardId shardId, Set<SegmentReplicationShardStats> replicaStats, long rejectedRequestCount) {
        this.shardId = shardId;
        this.replicaStats = replicaStats;
        this.rejectedRequestCount = rejectedRequestCount;
    }

    public SegmentReplicationPerGroupStats(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.replicaStats = in.readSet(SegmentReplicationShardStats::new);
        this.rejectedRequestCount = in.readVLong();
    }

    public Set<SegmentReplicationShardStats> getReplicaStats() {
        return this.replicaStats;
    }

    public long getRejectedRequestCount() {
        return this.rejectedRequestCount;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("rejected_requests", this.rejectedRequestCount);
        builder.startArray("replicas");
        for (SegmentReplicationShardStats stats : this.replicaStats) {
            stats.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeCollection(this.replicaStats);
        out.writeVLong(this.rejectedRequestCount);
    }

    public String toString() {
        return "SegmentReplicationPerGroupStats{replicaStats=" + String.valueOf(this.replicaStats) + ", rejectedRequestCount=" + this.rejectedRequestCount + "}";
    }
}

