/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index;

import io.skylite.OpenSearchVersion;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public class SegmentReplicationRejectionStats
implements Writeable,
ToXContentFragment {
    private long totalRejectionCount;

    public SegmentReplicationRejectionStats(long totalRejectionCount) {
        this.totalRejectionCount = totalRejectionCount;
    }

    public SegmentReplicationRejectionStats(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0)) {
            this.totalRejectionCount = in.readVLong();
        }
    }

    public long getTotalRejectionCount() {
        return this.totalRejectionCount;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("segment_replication_backpressure");
        builder.field("total_rejected_requests", this.totalRejectionCount);
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0)) {
            out.writeVLong(this.totalRejectionCount);
        }
    }

    public String toString() {
        return "SegmentReplicationRejectionStats{ totalRejectedRequestCount=" + this.totalRejectionCount + "}";
    }
}

