/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.cache;

import io.skylite.common.util.io.IOUtils;
import io.skylite.core.index.AbstractIndexComponent;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.cache.bitset.BitsetFilterCache;
import io.skylite.core.index.cache.query.QueryCache;
import java.io.Closeable;
import java.io.IOException;

public class IndexCache
extends AbstractIndexComponent
implements Closeable {
    private final QueryCache queryCache;
    private final BitsetFilterCache bitsetFilterCache;

    public IndexCache(IndexSettings indexSettings, QueryCache queryCache, BitsetFilterCache bitsetFilterCache) {
        super(indexSettings);
        this.queryCache = queryCache;
        this.bitsetFilterCache = bitsetFilterCache;
    }

    public QueryCache query() {
        return this.queryCache;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.bitsetFilterCache;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.queryCache, this.bitsetFilterCache});
    }

    public void clear(String reason) {
        this.queryCache.clear(reason);
        this.bitsetFilterCache.clear(reason);
    }
}

