/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.cache.bitset;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.cache.Cache;
import io.skylite.common.cache.CacheBuilder;
import io.skylite.common.cache.CacheLoader;
import io.skylite.common.cache.RemovalListener;
import io.skylite.common.cache.RemovalNotification;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.index.AbstractIndexComponent;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardUtils;
import io.skylite.core.index.warmer.IndexWarmer;
import io.skylite.core.index.warmer.ShardIndexWarmerService;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.mapper.DocumentMapper;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.ThreadPool;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;

public final class BitsetFilterCache
extends AbstractIndexComponent
implements IndexReader.ClosedListener,
RemovalListener<IndexReader.CacheKey, Cache<Query, Value>>,
Closeable {
    public static final Setting<Boolean> INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING = Setting.boolSetting("index.load_fixed_bitset_filters_eagerly", true, Setting.Property.IndexScope);
    private final boolean loadRandomAccessFiltersEagerly;
    private final Cache<IndexReader.CacheKey, Cache<Query, Value>> loadedFilters;
    private final Listener listener;

    public BitsetFilterCache(IndexSettings indexSettings, Listener listener) {
        super(indexSettings);
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.loadRandomAccessFiltersEagerly = this.indexSettings.getValue(INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING);
        this.loadedFilters = CacheBuilder.builder().removalListener((RemovalListener)this).build();
        this.listener = listener;
    }

    public static BitSet bitsetFromQuery(Query query, LeafReaderContext context) throws IOException {
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer s = weight.scorer(context);
        if (s == null) {
            return null;
        }
        return BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc());
    }

    public IndexWarmer.Listener createListener(ThreadPool threadPool) {
        return new BitSetProducerWarmer(threadPool);
    }

    public BitSetProducer getBitSetProducer(Query query) {
        return new QueryWrapperBitSetProducer(query);
    }

    public void onClose(IndexReader.CacheKey ownerCoreCacheKey) {
        this.loadedFilters.invalidate((Object)ownerCoreCacheKey);
    }

    @Override
    public void close() {
        this.clear("close");
    }

    public void clear(String reason) {
        this.logger.debug("clearing all bitsets because [{}]", (Object)reason);
        this.loadedFilters.invalidateAll();
    }

    private BitSet getAndLoadIfNotPresent(Query query, LeafReaderContext context) throws ExecutionException {
        IndexReader.CacheHelper cacheHelper = FilterLeafReader.unwrap((LeafReader)context.reader()).getCoreCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + String.valueOf(context.reader()) + " does not support caching");
        }
        IndexReader.CacheKey coreCacheReader = cacheHelper.getKey();
        ShardId shardId = ShardUtils.extractShardId(context.reader());
        if (!this.indexSettings.getIndex().equals(shardId.getIndex())) {
            throw new IllegalStateException("Trying to load bit set for index " + String.valueOf(shardId.getIndex()) + " with cache of index " + String.valueOf(this.indexSettings.getIndex()));
        }
        Cache filterToFbs = (Cache)this.loadedFilters.computeIfAbsent((Object)coreCacheReader, key -> {
            cacheHelper.addClosedListener((IndexReader.ClosedListener)this);
            return CacheBuilder.builder().build();
        });
        return ((Value)filterToFbs.computeIfAbsent((Object)query, (CacheLoader)(CacheLoader)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getAndLoadIfNotPresent$1(org.apache.lucene.search.Query org.apache.lucene.index.LeafReaderContext io.skylite.core.index.shard.ShardId org.apache.lucene.search.Query ), (Lorg/apache/lucene/search/Query;)Lio/skylite/core/index/cache/bitset/BitsetFilterCache$Value;)((BitsetFilterCache)this, (Query)query, (LeafReaderContext)context, (ShardId)shardId))).bitset;
    }

    public void onRemoval(RemovalNotification<IndexReader.CacheKey, Cache<Query, Value>> notification) {
        if (notification.getKey() == null) {
            return;
        }
        Cache valueCache = (Cache)notification.getValue();
        if (valueCache == null) {
            return;
        }
        for (Value value : valueCache.values()) {
            this.listener.onRemoval(value.shardId, (Accountable)value.bitset);
        }
    }

    Cache<IndexReader.CacheKey, Cache<Query, Value>> getLoadedFilters() {
        return this.loadedFilters;
    }

    private /* synthetic */ Value lambda$getAndLoadIfNotPresent$1(Query query, LeafReaderContext context, ShardId shardId, Query key) throws Exception {
        BitSet bitSet = BitsetFilterCache.bitsetFromQuery(query, context);
        Value value = new Value(bitSet, shardId);
        this.listener.onCache(shardId, (Accountable)value.bitset);
        return value;
    }

    public static interface Listener {
        public void onCache(ShardId var1, Accountable var2);

        public void onRemoval(ShardId var1, Accountable var2);
    }

    final class BitSetProducerWarmer
    implements IndexWarmer.Listener {
        private final Executor executor;

        BitSetProducerWarmer(ThreadPool threadPool) {
            this.executor = threadPool.executor("warmer");
        }

        @Override
        public IndexWarmer.TerminationHandle warmReader(Index index, MapperService mapperService, ShardIndexWarmerService warmerService, SkyliteDirectoryReader reader) {
            if (!BitsetFilterCache.this.indexSettings.getIndex().equals(index)) {
                return IndexWarmer.TerminationHandle.NO_WAIT;
            }
            if (!BitsetFilterCache.this.loadRandomAccessFiltersEagerly) {
                return IndexWarmer.TerminationHandle.NO_WAIT;
            }
            HashSet<Query> warmUp = new HashSet<Query>();
            DocumentMapper docMapper = mapperService.documentMapper();
            if (docMapper != null && docMapper.hasNestedObjects()) {
                warmUp.add(Queries.newNonNestedFilter());
                docMapper.getNestedParentMappers().stream().map(NestedObjectMapper::nestedTypeFilter).forEach(warmUp::add);
            }
            CountDownLatch latch = new CountDownLatch(reader.leaves().size() * warmUp.size());
            for (LeafReaderContext ctx : reader.leaves()) {
                for (Query filterToWarm : warmUp) {
                    this.executor.execute(() -> {
                        try {
                            long start = System.nanoTime();
                            BitsetFilterCache.this.getAndLoadIfNotPresent(filterToWarm, ctx);
                            if (warmerService.logger().isTraceEnabled()) {
                                warmerService.logger().trace("warmed bitset for [{}], took [{}]", (Object)filterToWarm, (Object)TimeValue.timeValueNanos((long)(System.nanoTime() - start)));
                            }
                        }
                        catch (Exception e) {
                            warmerService.logger().warn(() -> new ParameterizedMessage("failed to load bitset for [{}]", (Object)filterToWarm), (Throwable)e);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
            }
            return () -> latch.await();
        }
    }

    final class QueryWrapperBitSetProducer
    implements BitSetProducer {
        final Query query;

        QueryWrapperBitSetProducer(Query query) {
            this.query = Objects.requireNonNull(query);
        }

        public BitSet getBitSet(LeafReaderContext context) throws IOException {
            try {
                return BitsetFilterCache.this.getAndLoadIfNotPresent(this.query, context);
            }
            catch (ExecutionException e) {
                throw SkyliteExceptionsHelper.convertToOpenSearchException(e);
            }
        }

        public String toString() {
            return "random_access(" + String.valueOf(this.query) + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof QueryWrapperBitSetProducer)) {
                return false;
            }
            return this.query.equals((Object)((QueryWrapperBitSetProducer)o).query);
        }

        public int hashCode() {
            return 31 * this.getClass().hashCode() + this.query.hashCode();
        }
    }

    public static final class Value {
        final BitSet bitset;
        final ShardId shardId;

        public Value(BitSet bitset, ShardId shardId) {
            this.bitset = bitset;
            this.shardId = shardId;
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING);
        }
    }
}

