/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.cache.bitset;

import io.skylite.common.metrics.CounterMetric;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.shard.AbstractIndexShardComponent;
import io.skylite.core.index.shard.ShardId;

public class ShardBitsetFilterCache
extends AbstractIndexShardComponent {
    private final CounterMetric totalMetric = new CounterMetric();

    public ShardBitsetFilterCache(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public void onCached(long sizeInBytes) {
        this.totalMetric.inc(sizeInBytes);
    }

    public void onRemoval(long sizeInBytes) {
        this.totalMetric.dec(sizeInBytes);
    }

    public long getMemorySizeInBytes() {
        return this.totalMetric.count();
    }
}

