/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.codec;

import io.skylite.common.Nullable;
import io.skylite.common.collect.MapBuilder;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.codec.PerFieldMappingPostingFormatCodec;
import io.skylite.core.mapper.MapperService;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene103.Lucene103Codec;

public class CodecService {
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String LZ4 = "lz4";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String ZLIB = "zlib";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";

    public CodecService(@Nullable MapperService mapperService, IndexSettings indexSettings, Logger logger) {
        MapBuilder codecs = MapBuilder.newMapBuilder();
        assert (null != indexSettings);
        if (mapperService == null) {
            codecs.put((Object)DEFAULT_CODEC, (Object)new Lucene103Codec());
            codecs.put((Object)LZ4, (Object)new Lucene103Codec());
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new Lucene103Codec(Lucene103Codec.Mode.BEST_COMPRESSION));
            codecs.put((Object)ZLIB, (Object)new Lucene103Codec(Lucene103Codec.Mode.BEST_COMPRESSION));
        } else {
            codecs.put((Object)DEFAULT_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene103Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put((Object)LZ4, (Object)new PerFieldMappingPostingFormatCodec(Lucene103Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene103Codec.Mode.BEST_COMPRESSION, mapperService, logger));
            codecs.put((Object)ZLIB, (Object)new PerFieldMappingPostingFormatCodec(Lucene103Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        }
        codecs.put((Object)LUCENE_DEFAULT_CODEC, (Object)Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put((Object)codec, (Object)Codec.forName((String)codec));
        }
        this.codecs = codecs.immutableMap();
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }
}

