/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.common.Nullable;
import io.skylite.common.SetOnce;
import io.skylite.common.lifecycle.LifecycleAware;
import io.skylite.core.common.logging.Loggers;
import io.skylite.core.index.engine.EngineConfig;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.Store;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;

public abstract class BaseEngine
implements LifecycleAware,
Closeable {
    public static final String SYNC_COMMIT_ID = "sync_id";
    public static final String HISTORY_UUID_KEY = "history_uuid";
    public static final String MIN_RETAINED_SEQNO = "min_retained_seq_no";
    public static final String MAX_UNSAFE_AUTO_ID_TIMESTAMP_COMMIT_ID = "max_unsafe_auto_id_timestamp";
    public static final String SEARCH_SOURCE = "search";
    public static final String CAN_MATCH_SEARCH_SOURCE = "can_match";
    public static final String REASON_FORCE_MERGE = "force merge";
    public static final String MERGE_FAILED = "merge failed";
    protected final ShardId shardId;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected final Logger logger;
    protected final EngineConfig engineConfig;
    protected final Store store;
    protected final SetOnce<Exception> failedEngine = new SetOnce();

    public BaseEngine(EngineConfig engineConfig) {
        this.shardId = engineConfig.getShardId();
        this.logger = Loggers.getLogger(BaseEngine.class, engineConfig.getShardId(), new String[0]);
        this.engineConfig = engineConfig;
        this.store = engineConfig.getStore();
    }

    protected final void ensureOpen(Exception suppressed) {
        if (this.isClosed.get()) {
            AlreadyClosedException ace = new AlreadyClosedException(String.valueOf(this.shardId) + " engine is closed", (Throwable)this.failedEngine.get());
            if (suppressed != null) {
                ace.addSuppressed((Throwable)suppressed);
            }
            throw ace;
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public Store getStore() {
        return this.store;
    }

    public static interface EventListener {
        default public void onFailedEngine(String reason, @Nullable Exception e) {
        }
    }

    public static interface Warmer {
        public void warm(SkyliteDirectoryReader var1);
    }
}

