/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexCommit;

public final class CombinedDeletionPolicyUtils {
    private CombinedDeletionPolicyUtils() {
    }

    public static IndexCommit findSafeCommitPoint(List<IndexCommit> commits, long globalCheckpoint) throws IOException {
        if (commits.isEmpty()) {
            throw new IllegalArgumentException("Commit list must not be empty");
        }
        int keptPosition = CombinedDeletionPolicyUtils.indexOfKeptCommits(commits, globalCheckpoint);
        return commits.get(keptPosition);
    }

    public static int indexOfKeptCommits(List<? extends IndexCommit> commits, long globalCheckpoint) throws IOException {
        String expectedTranslogUUID = (String)commits.get(commits.size() - 1).getUserData().get("translog_uuid");
        for (int i = commits.size() - 1; i >= 0; --i) {
            Map commitUserData = commits.get(i).getUserData();
            if (!expectedTranslogUUID.equals(commitUserData.get("translog_uuid"))) {
                return i + 1;
            }
            long maxSeqNoFromCommit = Long.parseLong((String)commitUserData.get("max_seq_no"));
            if (maxSeqNoFromCommit > globalCheckpoint) continue;
            return i;
        }
        return 0;
    }
}

