/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.concurrent.GatedCloseable;
import io.skylite.common.concurrent.ReleasableLock;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.lifecycle.LifecycleAware;
import io.skylite.common.metrics.CounterMetric;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.ParseField;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.VersionType;
import io.skylite.core.index.engine.BaseEngine;
import io.skylite.core.index.engine.CommitStats;
import io.skylite.core.index.engine.EngineConfig;
import io.skylite.core.index.engine.EngineException;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.engine.SafeCommitInfo;
import io.skylite.core.index.engine.Segment;
import io.skylite.core.index.engine.SegmentsStats;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.index.merge.MergeStats;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.shard.DocsStats;
import io.skylite.core.index.translog.DefaultTranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogManager;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.lucene.uid.VersionsAndSeqNoResolver;
import io.skylite.core.mapper.DocumentParser;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.mapper.SeqNoFieldMapper;
import io.skylite.core.search.suggest.completion.CompletionStats;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;

public abstract class Engine
extends BaseEngine
implements LifecycleAware,
Closeable {
    private final CounterMetric totalUnreferencedFileCleanUpsPerformed = new CounterMetric();
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    protected final BaseEngine.EventListener eventListener;
    protected final ReentrantLock failEngineLock = new ReentrantLock();
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final ReleasableLock readLock = new ReleasableLock((Lock)this.rwl.readLock());
    protected final ReleasableLock writeLock = new ReleasableLock((Lock)this.rwl.writeLock());
    protected volatile long lastWriteNanos = System.nanoTime();

    protected Engine(EngineConfig engineConfig) {
        super(engineConfig);
        Objects.requireNonNull(engineConfig.getStore(), "Store must be provided to the engine");
        this.eventListener = engineConfig.getEventListener();
    }

    public final EngineConfig config() {
        return this.engineConfig;
    }

    public abstract TranslogManager translogManager();

    protected abstract SegmentInfos getLastCommittedSegmentInfos();

    @Nullable
    protected abstract SegmentInfos getLatestSegmentInfos();

    public GatedCloseable<SegmentInfos> getSegmentInfosSnapshot() {
        return new GatedCloseable((Object)this.getLatestSegmentInfos(), () -> {});
    }

    public MergeStats getMergeStats() {
        return new MergeStats();
    }

    public abstract String getHistoryUUID();

    String loadHistoryUUID(Map<String, String> commitData) {
        String uuid = commitData.get("history_uuid");
        if (uuid == null) {
            throw new IllegalStateException("commit doesn't contain history uuid");
        }
        return uuid;
    }

    public abstract long getWritingBytes();

    public abstract CompletionStats completionStats(String ... var1);

    public DocsStats docStats() {
        try (Searcher searcher = this.acquireSearcher("docStats", SearcherScope.INTERNAL);){
            DocsStats docsStats = this.docsStats(searcher.getIndexReader());
            return docsStats;
        }
    }

    protected final DocsStats docsStats(IndexReader indexReader) {
        long numDocs = 0L;
        long numDeletedDocs = 0L;
        long sizeInBytes = 0L;
        for (LeafReaderContext readerContext : indexReader.leaves()) {
            SegmentReader segmentReader = Lucene.segmentReader(readerContext.reader());
            SegmentCommitInfo info = segmentReader.getSegmentInfo();
            numDocs += (long)readerContext.reader().numDocs();
            numDeletedDocs += (long)readerContext.reader().numDeletedDocs();
            try {
                sizeInBytes += info.sizeInBytes();
            }
            catch (IOException e) {
                this.logger.trace(() -> new ParameterizedMessage("failed to get size for [{}]", (Object)info.info.name), (Throwable)e);
            }
        }
        return new DocsStats(numDocs, numDeletedDocs, sizeInBytes);
    }

    public long unreferencedFileCleanUpsPerformed() {
        return this.totalUnreferencedFileCleanUpsPerformed.count();
    }

    public void verifyEngineBeforeIndexClosing() throws IllegalStateException {
        long maxSeqNo;
        long globalCheckpoint = this.engineConfig.getGlobalCheckpointSupplier().getAsLong();
        if (globalCheckpoint != (maxSeqNo = this.getSeqNoStats(globalCheckpoint).getMaxSeqNo())) {
            throw new IllegalStateException("Global checkpoint [" + globalCheckpoint + "] mismatches maximum sequence number [" + maxSeqNo + "] on index shard " + String.valueOf(this.shardId));
        }
    }

    public long getMaxSeqNoFromSegmentInfos(SegmentInfos segmentInfos) throws IOException {
        try (DirectoryReader innerReader = StandardDirectoryReader.open((Directory)this.store.directory(), (SegmentInfos)segmentInfos, null, null);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)innerReader);
            long l = this.getMaxSeqNoFromSearcher(searcher);
            return l;
        }
    }

    protected long getMaxSeqNoFromSearcher(IndexSearcher searcher) throws IOException {
        searcher.setQueryCache(null);
        ScoreDoc[] docs = searcher.search((Query)Queries.newMatchAllQuery(), (int)1, (Sort)new Sort((SortField[])new SortField[]{new SortField((String)SeqNoFieldMapper.NAME, (SortField.Type)SortField.Type.LONG, (boolean)true)})).scoreDocs;
        if (docs.length == 0) {
            return -1L;
        }
        Document document = searcher.storedFields().document(docs[0].doc);
        Term uidTerm = new Term(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), document.getField(ParseField.CommonMetaFields.ID_FIELD.getPreferredName()).binaryValue());
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = VersionsAndSeqNoResolver.loadDocIdAndVersion(searcher.getIndexReader(), uidTerm, true);
        assert (docIdAndVersion != null);
        return docIdAndVersion.seqNo;
    }

    public abstract long getIndexThrottleTimeInMillis();

    public abstract boolean isThrottled();

    public abstract EngineResult.IndexResult index(EngineOperation.Index var1) throws IOException;

    public abstract EngineResult.DeleteResult delete(EngineOperation.Delete var1) throws IOException;

    public abstract EngineResult.NoOpResult noOp(EngineOperation.NoOp var1) throws IOException;

    protected final GetResult getFromSearcher(Get get, Searcher searcher, boolean uncachedLookup) throws EngineException {
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion;
        try {
            docIdAndVersion = uncachedLookup ? VersionsAndSeqNoResolver.loadDocIdAndVersionUncached(searcher.getIndexReader(), get.uid(), true) : VersionsAndSeqNoResolver.loadDocIdAndVersion(searcher.getIndexReader(), get.uid(), true);
        }
        catch (Exception e) {
            Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{searcher});
            throw new EngineException(this.shardId, "Couldn't resolve version", e, new Object[0]);
        }
        if (docIdAndVersion != null) {
            if (get.versionType().isVersionConflictForReads(docIdAndVersion.version, get.version())) {
                Releasables.close((Releasable)searcher);
                throw new VersionConflictEngineException(this.shardId, get.id(), get.versionType().explainConflictForReads(docIdAndVersion.version, get.version()));
            }
            if (get.getIfSeqNo() != -2L && (get.getIfSeqNo() != docIdAndVersion.seqNo || get.getIfPrimaryTerm() != docIdAndVersion.primaryTerm)) {
                Releasables.close((Releasable)searcher);
                throw new VersionConflictEngineException(this.shardId, get.id(), get.getIfSeqNo(), get.getIfPrimaryTerm(), docIdAndVersion.seqNo, docIdAndVersion.primaryTerm);
            }
        }
        if (docIdAndVersion != null) {
            return new GetResult(searcher, docIdAndVersion);
        }
        Releasables.close((Releasable)searcher);
        return GetResult.NOT_EXISTS;
    }

    public abstract GetResult get(Get var1, MappingLookup var2, DocumentParser var3, Function<Searcher, Searcher> var4) throws EngineException;

    public final SearcherSupplier acquireSearcherSupplier(Function<Searcher, Searcher> wrapper) throws EngineException {
        return this.acquireSearcherSupplier(wrapper, SearcherScope.EXTERNAL);
    }

    public SearcherSupplier acquireSearcherSupplier(Function<Searcher, Searcher> wrapper, final SearcherScope scope) throws EngineException {
        if (!this.store.tryIncRef()) {
            throw new AlreadyClosedException(String.valueOf(this.shardId) + " store is closed", (Throwable)this.failedEngine.get());
        }
        Releasable releasable = this.store::decRef;
        try {
            final ReferenceManager<SkyliteDirectoryReader> referenceManager = this.getReferenceManager(scope);
            final SkyliteDirectoryReader acquire = (SkyliteDirectoryReader)((Object)referenceManager.acquire());
            SearcherSupplier reader = new SearcherSupplier(wrapper){

                @Override
                public Searcher acquireSearcherInternal(String source) {
                    assert (Engine.this.assertSearcherIsWarmedUp(source, scope));
                    return new Searcher(source, (IndexReader)acquire, Engine.this.engineConfig.getSimilarity(), Engine.this.engineConfig.getQueryCache(), Engine.this.engineConfig.getQueryCachingPolicy(), () -> {});
                }

                @Override
                protected void doClose() {
                    try {
                        referenceManager.release((Object)acquire);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to close", e);
                    }
                    catch (AlreadyClosedException e) {
                        throw new AssertionError((Object)e);
                    }
                    finally {
                        Engine.this.store.decRef();
                    }
                }
            };
            releasable = null;
            SearcherSupplier searcherSupplier = reader;
            return searcherSupplier;
        }
        catch (AlreadyClosedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.maybeFailEngine("acquire_reader", ex);
            this.ensureOpen(ex);
            this.logger.error(() -> new ParameterizedMessage("failed to acquire reader", new Object[0]), (Throwable)ex);
            throw new EngineException(this.shardId, "failed to acquire reader", ex, new Object[0]);
        }
        finally {
            Releasables.close((Releasable)releasable);
        }
    }

    public final Searcher acquireSearcher(String source) throws EngineException {
        return this.acquireSearcher(source, SearcherScope.EXTERNAL);
    }

    public Searcher acquireSearcher(String source, SearcherScope scope) throws EngineException {
        return this.acquireSearcher(source, scope, Function.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Searcher acquireSearcher(String source, SearcherScope scope, Function<Searcher, Searcher> wrapper) throws EngineException {
        Searcher searcher;
        SearcherSupplier releasable = null;
        try {
            SearcherSupplier reader = releasable = this.acquireSearcherSupplier(wrapper, scope);
            Searcher searcher2 = reader.acquireSearcher(source);
            releasable = null;
            searcher = new Searcher(source, (IndexReader)searcher2.getDirectoryReader(), searcher2.getSimilarity(), searcher2.getQueryCache(), searcher2.getQueryCachingPolicy(), () -> Releasables.close((Releasable[])new Releasable[]{searcher2, reader}));
        }
        catch (Throwable throwable) {
            Releasables.close(releasable);
            throw throwable;
        }
        Releasables.close((Releasable)releasable);
        return searcher;
    }

    protected abstract ReferenceManager<SkyliteDirectoryReader> getReferenceManager(SearcherScope var1);

    boolean assertSearcherIsWarmedUp(String source, SearcherScope scope) {
        return true;
    }

    public abstract Closeable acquireHistoryRetentionLock();

    public abstract TranslogSnapshotIterator newChangesSnapshot(String var1, long var2, long var4, boolean var6, boolean var7) throws IOException;

    public abstract int countNumberOfHistoryOperations(String var1, long var2, long var4) throws IOException;

    public abstract boolean hasCompleteOperationHistory(String var1, long var2);

    public abstract long getMinRetainedSeqNo();

    public final void ensureOpen() {
        this.ensureOpen(null);
    }

    public final CommitStats commitStats() {
        return new CommitStats(this.getLastCommittedSegmentInfos());
    }

    public abstract long getPersistedLocalCheckpoint();

    public abstract long getProcessedLocalCheckpoint();

    public abstract SeqNoStats getSeqNoStats(long var1);

    public abstract long getLastSyncedGlobalCheckpoint();

    public SegmentsStats segmentsStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        SegmentReader segmentReader;
        this.ensureOpen();
        HashSet<String> segmentName = new HashSet<String>();
        SegmentsStats stats = new SegmentsStats();
        try (Searcher searcher = this.acquireSearcher("segments_stats", SearcherScope.INTERNAL);){
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                segmentReader = Lucene.segmentReader(ctx.reader());
                this.fillSegmentStats(segmentReader, includeSegmentFileSizes, stats);
                segmentName.add(segmentReader.getSegmentName());
            }
        }
        searcher = this.acquireSearcher("segments_stats", SearcherScope.EXTERNAL);
        try {
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                segmentReader = Lucene.segmentReader(ctx.reader());
                if (segmentName.contains(segmentReader.getSegmentName())) continue;
                this.fillSegmentStats(segmentReader, includeSegmentFileSizes, stats);
            }
        }
        finally {
            if (searcher != null) {
                searcher.close();
            }
        }
        this.writerSegmentStats(stats);
        return stats;
    }

    protected TranslogDeletionPolicy getTranslogDeletionPolicy(EngineConfig engineConfig) {
        TranslogDeletionPolicy customTranslogDeletionPolicy = null;
        if (engineConfig.getCustomTranslogDeletionPolicyFactory() != null) {
            customTranslogDeletionPolicy = engineConfig.getCustomTranslogDeletionPolicyFactory().create(engineConfig.getIndexSettings(), engineConfig.retentionLeasesSupplier());
        }
        return Objects.requireNonNullElseGet(customTranslogDeletionPolicy, () -> new DefaultTranslogDeletionPolicy(engineConfig.getIndexSettings().getTranslogRetentionSize().getBytes(), engineConfig.getIndexSettings().getTranslogRetentionAge().getMillis(), engineConfig.getIndexSettings().getTranslogRetentionTotalFiles()));
    }

    protected void fillSegmentStats(SegmentReader segmentReader, boolean includeSegmentFileSizes, SegmentsStats stats) {
        stats.add(1L);
        if (includeSegmentFileSizes) {
            stats.addFileSizes(this.getSegmentFileSizes(segmentReader));
        }
    }

    boolean shouldCleanupUnreferencedFiles() {
        return this.engineConfig.getIndexSettings().shouldCleanupUnreferencedFiles();
    }

    private Map<String, Long> getSegmentFileSizes(SegmentReader segmentReader) {
        String[] files;
        Directory directory = null;
        SegmentCommitInfo segmentCommitInfo = segmentReader.getSegmentInfo();
        boolean useCompoundFile = segmentCommitInfo.info.getUseCompoundFile();
        if (useCompoundFile) {
            try {
                directory = this.engineConfig.getCodec().compoundFormat().getCompoundReader(segmentReader.directory(), segmentCommitInfo.info);
            }
            catch (IOException e) {
                this.logger.warn(() -> new ParameterizedMessage("Error when opening compound reader for Directory [{}] and SegmentCommitInfo [{}]", (Object)segmentReader.directory(), (Object)segmentCommitInfo), (Throwable)e);
                return Map.of();
            }
        } else {
            directory = segmentReader.directory();
        }
        assert (directory != null);
        if (useCompoundFile) {
            try {
                files = directory.listAll();
            }
            catch (IOException e) {
                Directory finalDirectory = directory;
                this.logger.warn(() -> new ParameterizedMessage("Couldn't list Compound Reader Directory [{}]", (Object)finalDirectory), (Throwable)e);
                return Map.of();
            }
        }
        try {
            files = segmentReader.getSegmentInfo().files().toArray(new String[0]);
        }
        catch (IOException e) {
            this.logger.warn(() -> new ParameterizedMessage("Couldn't list Directory from SegmentReader [{}] and SegmentInfo [{}]", (Object)segmentReader, (Object)segmentReader.getSegmentInfo()), (Throwable)e);
            return Map.of();
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (String file : files) {
            Directory finalDirectory;
            String extension = IndexFileNames.getExtension((String)file);
            long length = 0L;
            try {
                length = directory.fileLength(file);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                finalDirectory = directory;
                this.logger.warn(() -> new ParameterizedMessage("Tried to query fileLength but file is gone [{}] [{}]", (Object)finalDirectory, (Object)file), (Throwable)e);
            }
            catch (IOException e) {
                finalDirectory = directory;
                this.logger.warn(() -> new ParameterizedMessage("Error when trying to query fileLength [{}] [{}]", (Object)finalDirectory, (Object)file), (Throwable)e);
            }
            if (length == 0L) continue;
            map.put(extension, length);
        }
        if (useCompoundFile) {
            try {
                directory.close();
            }
            catch (IOException e) {
                Directory finalDirectory = directory;
                this.logger.warn(() -> new ParameterizedMessage("Error when closing compound reader on Directory [{}]", (Object)finalDirectory), (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    protected void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(0L);
        stats.addIndexWriterMemoryInBytes(0L);
    }

    public abstract long getIndexBufferRAMBytesUsed();

    public final Segment[] getSegmentInfo(SegmentInfos lastCommittedSegmentInfos, boolean verbose) {
        this.ensureOpen();
        HashMap<String, Segment> segments = new HashMap<String, Segment>();
        try (Object searcher = this.acquireSearcher("segments", SearcherScope.EXTERNAL);){
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                this.fillSegmentInfo(Lucene.segmentReader(ctx.reader()), verbose, true, segments);
            }
        }
        searcher = this.acquireSearcher("segments", SearcherScope.INTERNAL);
        try {
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader(ctx.reader());
                if (segments.containsKey(segmentReader.getSegmentName())) continue;
                this.fillSegmentInfo(segmentReader, verbose, false, segments);
            }
        }
        finally {
            if (searcher != null) {
                ((Searcher)((Object)searcher)).close();
            }
        }
        if (lastCommittedSegmentInfos != null) {
            for (SegmentCommitInfo info : lastCommittedSegmentInfos) {
                Segment segment = (Segment)segments.get(info.info.name);
                if (segment == null) {
                    segment = new Segment(info.info.name);
                    segment.search = false;
                    segment.committed = true;
                    segment.delDocCount = info.getDelCount() + info.getSoftDelCount();
                    segment.docCount = info.info.maxDoc() - segment.delDocCount;
                    segment.version = info.info.getVersion();
                    segment.compound = info.info.getUseCompoundFile();
                    try {
                        segment.sizeInBytes = info.sizeInBytes();
                    }
                    catch (IOException e) {
                        this.logger.trace(() -> new ParameterizedMessage("failed to get size for [{}]", (Object)info.info.name), (Throwable)e);
                    }
                    segment.segmentSort = info.info.getIndexSort();
                    segment.attributes = info.info.getAttributes();
                    segments.put(info.info.name, segment);
                    continue;
                }
                segment.committed = true;
            }
        }
        Segment[] segmentsArr = segments.values().toArray(new Segment[0]);
        Arrays.sort(segmentsArr, Comparator.comparingLong(Segment::getGeneration));
        return segmentsArr;
    }

    private void fillSegmentInfo(SegmentReader segmentReader, boolean verbose, boolean search, Map<String, Segment> segments) {
        SegmentCommitInfo info = segmentReader.getSegmentInfo();
        assert (!segments.containsKey(info.info.name));
        Segment segment = new Segment(info.info.name);
        segment.search = search;
        segment.docCount = segmentReader.numDocs();
        segment.delDocCount = segmentReader.numDeletedDocs();
        segment.version = info.info.getVersion();
        segment.compound = info.info.getUseCompoundFile();
        try {
            segment.sizeInBytes = info.sizeInBytes();
        }
        catch (IOException e) {
            this.logger.trace(() -> new ParameterizedMessage("failed to get size for [{}]", (Object)info.info.name), (Throwable)e);
        }
        segment.segmentSort = info.info.getIndexSort();
        segment.attributes = info.info.getAttributes();
        segments.put(info.info.name, segment);
    }

    public abstract List<Segment> segments(boolean var1);

    public boolean refreshNeeded() {
        if (this.store.tryIncRef()) {
            try {
                Searcher searcher = this.acquireSearcher("refresh_needed", SearcherScope.EXTERNAL);
                try {
                    boolean bl;
                    boolean bl2 = bl = !searcher.getDirectoryReader().isCurrent();
                    if (searcher != null) {
                        searcher.close();
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        if (searcher != null) {
                            try {
                                searcher.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.error("failed to access searcher manager", (Throwable)e);
                        this.failEngine("failed to access searcher manager", e);
                        throw new EngineException(this.shardId, "failed to access searcher manager", e, new Object[0]);
                    }
                }
            }
            finally {
                this.store.decRef();
            }
        }
        return false;
    }

    @Nullable
    public abstract void refresh(String var1) throws EngineException;

    @Nullable
    public abstract boolean maybeRefresh(String var1) throws EngineException;

    public abstract void writeIndexingBuffer() throws EngineException;

    public abstract boolean shouldPeriodicallyFlush();

    public abstract void flush(boolean var1, boolean var2) throws EngineException;

    public final void flush() throws EngineException {
        this.flush(false, false);
    }

    public abstract void forceMerge(boolean var1, int var2, boolean var3, boolean var4, boolean var5, String var6) throws EngineException, IOException;

    public abstract GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean var1) throws EngineException;

    public abstract GatedCloseable<IndexCommit> acquireSafeIndexCommit() throws EngineException;

    public abstract SafeCommitInfo getSafeCommitInfo();

    private void maybeDie(String maybeMessage, Throwable maybeFatal) {
        ExceptionsHelper.maybeError((Throwable)maybeFatal).ifPresent(error -> {
            try {
                this.logger.error(maybeMessage, (Throwable)error);
            }
            finally {
                throw error;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failEngine(String reason, @Nullable Exception failure) {
        if (failure != null) {
            this.maybeDie(reason, failure);
        }
        if (this.failEngineLock.tryLock()) {
            try {
                if (this.failedEngine.get() != null) {
                    this.logger.warn(() -> new ParameterizedMessage("tried to fail engine but engine is already failed. ignoring. [{}]", (Object)reason), (Throwable)failure);
                    return;
                }
                this.failedEngine.set((Object)(failure != null ? failure : new IllegalStateException(reason)));
                try {
                    this.closeNoLock("engine failed on: [" + reason + "]", this.closedLatch);
                }
                finally {
                    this.logger.warn(() -> new ParameterizedMessage("failed engine [{}]", (Object)reason), (Throwable)failure);
                    if (Lucene.isCorruptionException(failure)) {
                        if (this.store.tryIncRef()) {
                            try {
                                this.store.markStoreCorrupted(new IOException("failed engine (reason: [" + reason + "])", SkyliteExceptionsHelper.unwrapCorruption(failure)));
                            }
                            catch (IOException e) {
                                this.logger.warn("Couldn't mark store corrupted", (Throwable)e);
                            }
                            finally {
                                this.store.decRef();
                            }
                        } else {
                            this.logger.warn(() -> new ParameterizedMessage("tried to mark store as corrupted but store is already closed. [{}]", (Object)reason), (Throwable)failure);
                        }
                    }
                    if (this.shouldCleanupUnreferencedFiles() && this.isMergeFailureDueToIOException(failure, reason)) {
                        this.cleanUpUnreferencedFiles();
                    }
                    this.eventListener.onFailedEngine(reason, failure);
                }
            }
            catch (Exception inner) {
                if (failure != null) {
                    inner.addSuppressed(failure);
                }
                this.logger.warn("failEngine threw exception", (Throwable)inner);
            }
        } else {
            this.logger.debug(() -> new ParameterizedMessage("tried to fail engine but could not acquire lock - engine should be failed by now [{}]", (Object)reason), (Throwable)failure);
        }
    }

    private void cleanUpUnreferencedFiles() {
        try (IndexWriter writer = new IndexWriter(this.store.directory(), new IndexWriterConfig((Analyzer)Lucene.STANDARD_ANALYZER).setSoftDeletesField("__soft_deletes").setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND));){
            this.totalUnreferencedFileCleanUpsPerformed.inc();
        }
        catch (Exception ex) {
            this.logger.error("Error while deleting unreferenced file ", (Throwable)ex);
        }
    }

    private boolean isMergeFailureDueToIOException(Exception failure, String reason) {
        return (reason.equals("force merge") || reason.equals("merge failed")) && SkyliteExceptionsHelper.unwrap(failure, IOException.class) instanceof IOException;
    }

    protected boolean maybeFailEngine(String source, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            this.failEngine("corrupt file (source: [" + source + "])", e);
            return true;
        }
        return false;
    }

    protected abstract void closeNoLock(String var1, CountDownLatch var2);

    public void flushAndClose() throws IOException {
        if (!this.isClosed.get()) {
            this.logger.trace("flushAndClose now acquire writeLock");
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.logger.trace("flushAndClose now acquired writeLock");
                try {
                    this.logger.debug("flushing shard on close - this might take some time to sync files to disk");
                    try {
                        this.flush();
                    }
                    catch (AlreadyClosedException ex) {
                        this.logger.debug("engine already closed - skipping flushAndClose");
                    }
                }
                finally {
                    this.close();
                }
            }
        }
        this.awaitPendingClose();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.get()) {
            this.logger.debug("close now acquiring writeLock");
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.logger.debug("close acquired writeLock");
                this.closeNoLock("api", this.closedLatch);
            }
        }
        this.awaitPendingClose();
    }

    private void awaitPendingClose() {
        try {
            this.closedLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onSettingsChanged(TimeValue translogRetentionAge, ByteSizeValue translogRetentionSize, long softDeletesRetentionOps) {
    }

    public long getLastWriteNanos() {
        return this.lastWriteNanos;
    }

    public abstract void activateThrottling();

    public abstract void deactivateThrottling();

    public abstract int fillSeqNoGaps(long var1) throws IOException;

    public abstract void maybePruneDeletes();

    public long getMaxSeenAutoIdTimestamp() {
        return -1L;
    }

    public abstract void updateMaxUnsafeAutoIdTimestamp(long var1);

    public abstract long getMaxSeqNoOfUpdatesOrDeletes();

    public abstract void advanceMaxSeqNoOfUpdatesOrDeletes(long var1);

    public static enum SearcherScope {
        EXTERNAL,
        INTERNAL;

    }

    public static final class Searcher
    extends IndexSearcher
    implements Releasable {
        private final String source;
        private final Closeable onClose;

        public Searcher(String source, IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, Closeable onClose) {
            super(reader);
            this.setSimilarity(similarity);
            this.setQueryCache(queryCache);
            this.setQueryCachingPolicy(queryCachingPolicy);
            this.source = source;
            this.onClose = onClose;
        }

        public String source() {
            return this.source;
        }

        public DirectoryReader getDirectoryReader() {
            if (this.getIndexReader() instanceof DirectoryReader) {
                return (DirectoryReader)this.getIndexReader();
            }
            throw new IllegalStateException("Can't use " + String.valueOf(this.getIndexReader().getClass()) + " as a directory reader");
        }

        public void close() {
            try {
                this.onClose.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("failed to close", e);
            }
            catch (AlreadyClosedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static class Get {
        private final boolean realtime;
        private final Term uid;
        private final String id;
        private final boolean readFromTranslog;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;
        private long ifSeqNo = -2L;
        private long ifPrimaryTerm = 0L;

        public Get(boolean realtime, boolean readFromTranslog, String id, Term uid) {
            this.realtime = realtime;
            this.id = id;
            this.uid = uid;
            this.readFromTranslog = readFromTranslog;
        }

        public boolean realtime() {
            return this.realtime;
        }

        public String id() {
            return this.id;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public Get version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Get versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public boolean isReadFromTranslog() {
            return this.readFromTranslog;
        }

        public Get setIfSeqNo(long seqNo) {
            this.ifSeqNo = seqNo;
            return this;
        }

        public long getIfSeqNo() {
            return this.ifSeqNo;
        }

        public Get setIfPrimaryTerm(long primaryTerm) {
            this.ifPrimaryTerm = primaryTerm;
            return this;
        }

        public long getIfPrimaryTerm() {
            return this.ifPrimaryTerm;
        }
    }

    public static class GetResult
    implements Releasable {
        private final boolean exists;
        private final long version;
        private final VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion;
        private final Searcher searcher;
        public static final GetResult NOT_EXISTS = new GetResult(false, -1L, null, null);

        private GetResult(boolean exists, long version, VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion, Searcher searcher) {
            this.exists = exists;
            this.version = version;
            this.docIdAndVersion = docIdAndVersion;
            this.searcher = searcher;
        }

        public GetResult(Searcher searcher, VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion) {
            this(true, docIdAndVersion.version, docIdAndVersion, searcher);
        }

        public boolean exists() {
            return this.exists;
        }

        public long version() {
            return this.version;
        }

        public Searcher searcher() {
            return this.searcher;
        }

        public VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion() {
            return this.docIdAndVersion;
        }

        public void close() {
            Releasables.close((Releasable)this.searcher);
        }
    }

    public static abstract class SearcherSupplier
    implements Releasable {
        private final Function<Searcher, Searcher> wrapper;
        private final AtomicBoolean released = new AtomicBoolean(false);

        public SearcherSupplier(Function<Searcher, Searcher> wrapper) {
            this.wrapper = wrapper;
        }

        public final Searcher acquireSearcher(String source) {
            if (this.released.get()) {
                throw new AlreadyClosedException("SearcherSupplier was closed");
            }
            Searcher searcher = this.acquireSearcherInternal(source);
            return "can_match".equals(source) ? searcher : this.wrapper.apply(searcher);
        }

        public final void close() {
            if (this.released.compareAndSet(false, true)) {
                this.doClose();
            } else assert (false) : "SearchSupplier was released twice";
        }

        protected abstract void doClose();

        protected abstract Searcher acquireSearcherInternal(String var1);
    }

    protected static final class NoOpLock
    implements Lock {
        protected NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("NoOpLock can't provide a condition");
        }
    }

    protected static final class IndexThrottle {
        private final CounterMetric throttleTimeMillisMetric = new CounterMetric();
        private volatile long startOfThrottleNS;
        private static final ReleasableLock NOOP_LOCK = new ReleasableLock((Lock)new NoOpLock());
        private final ReleasableLock lockReference = new ReleasableLock((Lock)new ReentrantLock());
        private volatile ReleasableLock lock = NOOP_LOCK;

        protected IndexThrottle() {
        }

        public Releasable acquireThrottle() {
            return this.lock.acquire();
        }

        public void activate() {
            assert (this.lock == NOOP_LOCK) : "throttling activated while already active";
            this.startOfThrottleNS = System.nanoTime();
            this.lock = this.lockReference;
        }

        public void deactivate() {
            assert (this.lock != NOOP_LOCK) : "throttling deactivated but not active";
            this.lock = NOOP_LOCK;
            assert (this.startOfThrottleNS > 0L) : "Bad state of startOfThrottleNS";
            long throttleTimeNS = System.nanoTime() - this.startOfThrottleNS;
            if (throttleTimeNS >= 0L) {
                this.throttleTimeMillisMetric.inc(TimeValue.nsecToMSec((long)throttleTimeNS));
            }
        }

        long getThrottleTimeInMillis() {
            long currentThrottleNS = 0L;
            if (this.isThrottled() && this.startOfThrottleNS != 0L && (currentThrottleNS += System.nanoTime() - this.startOfThrottleNS) < 0L) {
                currentThrottleNS = 0L;
            }
            return this.throttleTimeMillisMetric.count() + TimeValue.nsecToMSec((long)currentThrottleNS);
        }

        boolean isThrottled() {
            return this.lock != NOOP_LOCK;
        }

        boolean throttleLockIsHeldByCurrentThread() {
            if (this.isThrottled()) {
                return this.lock.isHeldByCurrentThread();
            }
            return false;
        }
    }
}

